/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.task;

import com.github.bunnyi116.bedrockminer.BedrockMiner;
import com.github.bunnyi116.bedrockminer.I18n;
import com.github.bunnyi116.bedrockminer.config.Config;
import com.github.bunnyi116.bedrockminer.task.Task;
import com.github.bunnyi116.bedrockminer.task.TaskRegion;
import com.github.bunnyi116.bedrockminer.task.TaskState;
import com.github.bunnyi116.bedrockminer.util.CombinedIterator;
import com.github.bunnyi116.bedrockminer.util.MessageUtils;
import com.github.bunnyi116.bedrockminer.util.block.BlockUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerInventoryUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerLookUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class TaskManager {
    @Nullable
    private static volatile TaskManager INSTANCE;
    private final ArrayList<Task> pendingBlockTasks = new ArrayList();
    private final ArrayList<Task> activeBlockTasks = new ArrayList();
    private final ArrayList<Task> cacheBlockTasks = new ArrayList();
    private final List<TaskRegion> pendingRegionTasks = new ArrayList<TaskRegion>();
    private boolean running;
    private boolean processing;
    private boolean bedrockMinerFeatureEnable = true;
    private int sortCount;

    public void tick() {
        if (!BedrockMiner.gameVariableIsValid()) {
            return;
        }
        if (Config.getInstance().disable || !this.isRunning()) {
            PlayerLookUtils.tick();
            return;
        }
        if (this.pendingBlockTasks.isEmpty() && this.pendingRegionTasks.isEmpty() && Config.getInstance().ranges.isEmpty()) {
            this.removeBlockTaskAll();
            return;
        }
        if (!this.isAllowExecutionEnvironment(this.activeBlockTasks.isEmpty())) {
            return;
        }
        if (!this.pendingBlockTasks.isEmpty() || !this.activeBlockTasks.isEmpty()) {
            if (this.sortCount > 0) {
                --this.sortCount;
            } else {
                this.sortCount = 40;
                if (this.pendingBlockTasks.size() > 1) {
                    this.pendingBlockTasks.sort((a1, a2) -> {
                        int dy = a2.pos.method_10264() - a1.pos.method_10264();
                        if (dy != 0) {
                            return dy;
                        }
                        double dist1 = PlayerUtils.getHorizontalDistanceToPlayer(a1.pos);
                        double dist2 = PlayerUtils.getHorizontalDistanceToPlayer(a2.pos);
                        return Double.compare(dist1, dist2);
                    });
                }
                if (this.activeBlockTasks.size() > 1) {
                    this.activeBlockTasks.sort((a1, a2) -> Boolean.compare(a1.isNeedModify(), a2.isNeedModify()));
                }
            }
        }
        boolean execute = false;
        boolean requestPickaxe = false;
        boolean modifyLook = false;
        if (!this.activeBlockTasks.isEmpty()) {
            if (this.activeBlockTasks.size() > 1) {
                for (Task entry : this.activeBlockTasks) {
                    if (entry == null) continue;
                    if (entry.getCurrentState() == TaskState.EXECUTE) {
                        execute = true;
                        break;
                    }
                    if (!entry.isRequestPickaxe()) continue;
                    requestPickaxe = true;
                    break;
                }
            }
            int resetCountMax = 20;
            Iterator<Task> iterator = this.activeBlockTasks.iterator();
            while (iterator.hasNext()) {
                Task currentTask = iterator.next();
                if (currentTask == null) continue;
                if (currentTask.world != BedrockMiner.world || !currentTask.canInteractWithBlockAt()) {
                    MessageUtils.setOverlayMessage((class_2561)class_2561.method_43470((String)("\u8fdc\u79bb\u5f53\u524d\u6b63\u5728\u5904\u7406\u7684\u65b9\u5757\u4f4d\u7f6e, \u51b7\u5374\u65f6\u95f4\u5269\u4f59: " + (resetCountMax - currentTask.active))));
                    continue;
                }
                if (currentTask.active >= resetCountMax) {
                    if (this.pendingBlockTasks.size() > 1 || !this.pendingRegionTasks.isEmpty() || !Config.getInstance().ranges.isEmpty()) {
                        this.cacheBlockTasks.add(currentTask);
                        iterator.remove();
                        currentTask.active = 0;
                        continue;
                    }
                } else {
                    ++currentTask.active;
                }
                this.processing = true;
                if (PlayerLookUtils.getTask() != null && !this.activeBlockTasks.contains(PlayerLookUtils.getTask())) {
                    PlayerLookUtils.reset();
                }
                if (PlayerLookUtils.isModify()) {
                    if (PlayerLookUtils.getTask() != currentTask) continue;
                    modifyLook = true;
                }
                if (execute && currentTask.getCurrentState() != TaskState.EXECUTE || requestPickaxe && !currentTask.isRequestPickaxe()) continue;
                currentTask.tick();
                currentTask.active = 0;
                switch (currentTask.getCurrentState()) {
                    case EXECUTE: {
                        if (currentTask.planItem != null && !currentTask.planItem.piston.isNeedModify()) {
                            execute = true;
                            break;
                        }
                        return;
                    }
                    case RECYCLED_ITEMS: {
                        return;
                    }
                }
                this.processing = false;
                if (currentTask.isComplete()) {
                    iterator.remove();
                    this.pendingBlockTasks.remove(currentTask);
                    currentTask.active = 0;
                    continue;
                }
                if (!modifyLook) continue;
                return;
            }
            if (this.activeBlockTasks.size() >= Config.getInstance().limitMax) {
                return;
            }
        }
        if (!this.cacheBlockTasks.isEmpty()) {
            Iterator<Task> iterator = this.cacheBlockTasks.iterator();
            while (iterator.hasNext()) {
                class_2680 blockState;
                Task task = iterator.next();
                if (task == null || (blockState = BedrockMiner.world.method_8320(task.pos)).method_26215() || BlockUtils.isReplaceable(blockState) || task.world != BedrockMiner.world || !task.canInteractWithBlockAt() || PlayerLookUtils.isModify() && PlayerLookUtils.getTask() != task) continue;
                iterator.remove();
                this.activeBlockTasks.add(task);
                if (this.activeBlockTasks.size() >= Config.getInstance().limitMax) {
                    return;
                }
                return;
            }
        }
        double playerBlockInteractionRange = PlayerUtils.getBlockInteractionRange();
        int radius = (int)Math.ceil(playerBlockInteractionRange);
        Iterator<Task> iterator = this.pendingBlockTasks.iterator();
        while (iterator.hasNext() && this.activeBlockTasks.size() < Config.getInstance().limitMax) {
            Task task = iterator.next();
            if (task == null) continue;
            class_2680 blockState = BedrockMiner.world.method_8320(task.pos);
            class_2248 block = blockState.method_26204();
            if (blockState.method_26215() || BlockUtils.isReplaceable(blockState) || !Config.getInstance().isAllowBlock(block) || Config.getInstance().isFloorsBlacklist(task.pos) || !task.canInteractWithBlockAt()) continue;
            if (task.world != BedrockMiner.world) {
                iterator.remove();
            }
            if (!this.activeBlockTasks.contains(task)) {
                this.activeBlockTasks.add(task);
            }
            if (this.activeBlockTasks.size() < Config.getInstance().limitMax) continue;
            return;
        }
        if (this.activeBlockTasks.size() < Config.getInstance().limitMax) {
            CombinedIterator<TaskRegion> iterator2 = new CombinedIterator<TaskRegion>(Config.getInstance().ranges, this.pendingRegionTasks);
            while (iterator2.hasNext()) {
                class_3341 playerBox;
                class_3341 playerExpandBox;
                class_3341 rangeBox;
                TaskRegion range = iterator2.next();
                if (!range.isForWorld((class_1937)BedrockMiner.world) || !(rangeBox = class_3341.method_34390((class_2382)range.pos1, (class_2382)range.pos2)).method_14657(playerExpandBox = (playerBox = new class_3341(BedrockMiner.player.method_24515())).method_35410(radius))) continue;
                for (int dy = radius; dy > -radius; --dy) {
                    for (int dx = -radius; dx <= radius; ++dx) {
                        for (int dz = -radius; dz <= radius; ++dz) {
                            Task task;
                            class_2338 blockPos = BedrockMiner.player.method_24515().method_10069(dx, dy, dz);
                            if (!PlayerUtils.canInteractWithBlockAt(blockPos, 1.0)) continue;
                            class_2680 blockState = BedrockMiner.world.method_8320(blockPos);
                            class_2248 block = blockState.method_26204();
                            if (blockState.method_26215() || BlockUtils.isReplaceable(blockState) || !Config.getInstance().isAllowBlock(block) || Config.getInstance().isFloorsBlacklist(blockPos) || !(task = new Task(BedrockMiner.world, block, blockPos)).canInteractWithBlockAt() || PlayerLookUtils.isModify() && PlayerLookUtils.getTask() != task) continue;
                            if (task.world != BedrockMiner.world) {
                                iterator2.remove();
                                continue;
                            }
                            if (!this.activeBlockTasks.contains(task)) {
                                this.activeBlockTasks.add(task);
                            }
                            if (this.activeBlockTasks.size() < Config.getInstance().limitMax) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    public boolean isAllowExecutionEnvironment(boolean setOverlayMessage) {
        class_2561 msg = null;
        if (BedrockMiner.gameMode.method_8386()) {
            msg = I18n.FAIL_MISSING_SURVIVAL;
        }
        if (BedrockMiner.interactionManager != null && !BedrockMiner.interactionManager.method_2920().method_8388()) {
            msg = I18n.FAIL_MISSING_SURVIVAL;
        }
        if (PlayerInventoryUtils.getInventoryItemCount(class_1802.field_8249) < 2) {
            msg = I18n.FAIL_MISSING_PISTON;
        }
        if (PlayerInventoryUtils.getInventoryItemCount(class_1802.field_8530) < 1) {
            msg = I18n.FAIL_MISSING_REDSTONETORCH;
        }
        if (!PlayerInventoryUtils.canInstantlyMinePiston()) {
            msg = I18n.FAIL_MISSING_INSTANTMINE;
        }
        if (msg != null) {
            if (setOverlayMessage) {
                MessageUtils.setOverlayMessage(msg);
            }
            return false;
        }
        return true;
    }

    public void addBlockTask(class_638 world, class_2338 pos, class_2248 block) {
        if (Config.getInstance().disable || !this.isRunning()) {
            return;
        }
        if (!this.isAllowExecutionEnvironment(true)) {
            return;
        }
        if (!BedrockMiner.gameMode.method_8388()) {
            return;
        }
        if (!Config.getInstance().isAllowBlock(block)) {
            return;
        }
        if (Config.getInstance().isFloorsBlacklist(pos)) {
            String msg = I18n.FLOOR_BLACK_LIST_WARN.getString().replace("(#floor#)", String.valueOf(pos.method_10264()));
            MessageUtils.setOverlayMessage((class_2561)class_2561.method_43470((String)msg));
            return;
        }
        for (Task targetBlock : this.pendingBlockTasks) {
            if (!targetBlock.pos.equals((Object)pos)) continue;
            return;
        }
        this.pendingBlockTasks.add(new Task(world, block, pos));
    }

    public void removeBlockTask(class_638 world, class_2338 pos) {
        Iterator<Task> iterator = this.pendingBlockTasks.iterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            if (!task.pos.equals((Object)pos)) continue;
            iterator.remove();
            return;
        }
    }

    public void removeBlockTaskAll() {
        this.activeBlockTasks.clear();
        this.cacheBlockTasks.clear();
        this.pendingBlockTasks.clear();
    }

    public void addRegionTask(String name, class_638 world, class_2338 pos1, class_2338 pos2) {
        for (TaskRegion range : this.pendingRegionTasks) {
            if (!range.name.equals(name)) continue;
            return;
        }
        this.pendingRegionTasks.add(new TaskRegion(name, (class_1937)world, pos1, pos2));
    }

    public void removeRegionTaskAll(String name) {
        Iterator<TaskRegion> iterator = this.pendingRegionTasks.iterator();
        while (iterator.hasNext()) {
            TaskRegion range = iterator.next();
            if (!range.name.equals(name)) continue;
            iterator.remove();
            return;
        }
    }

    public void removeRegionTaskAll() {
        this.pendingRegionTasks.clear();
    }

    public void removeAll() {
        this.removeAll(true);
    }

    public void removeAll(boolean showMessage) {
        this.removeBlockTaskAll();
        this.removeRegionTaskAll();
        if (showMessage) {
            MessageUtils.addMessage(I18n.COMMAND_TASK_CLEAR);
        }
    }

    public void switchToggle(@Nullable class_2248 block) {
        if (Config.getInstance().disable || !Config.getInstance().isAllowBlock(block)) {
            return;
        }
        this.switchToggle();
    }

    public void switchToggle() {
        if (this.isRunning()) {
            this.removeAll();
            this.setRunning(false);
        } else {
            if (BedrockMiner.gameMode.method_8386()) {
                MessageUtils.addMessage(I18n.FAIL_MISSING_SURVIVAL);
                return;
            }
            this.setRunning(true);
            if (!BedrockMiner.client.method_1542()) {
                MessageUtils.addMessage(I18n.WARN_MULTIPLAYER);
            }
        }
    }

    public void setRunning(boolean running) {
        this.setRunning(running, true);
    }

    public void setRunning(boolean running, boolean showMessage) {
        if (showMessage) {
            if (running) {
                MessageUtils.addMessage(I18n.TOGGLE_ON);
            } else {
                MessageUtils.addMessage(I18n.TOGGLE_OFF);
            }
        }
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public boolean isInTasks(class_638 world, class_2338 pos) {
        for (Task targetBlock : this.pendingBlockTasks) {
            if (!targetBlock.pos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    public boolean isBedrockMinerFeatureEnable() {
        return this.bedrockMinerFeatureEnable;
    }

    public void setBedrockMinerFeatureEnable(boolean bedrockMinerFeatureEnable) {
        this.bedrockMinerFeatureEnable = bedrockMinerFeatureEnable;
    }

    public List<Task> getPendingBlockTasks() {
        return this.pendingBlockTasks;
    }

    public List<TaskRegion> getPendingRegionTasks() {
        return this.pendingRegionTasks;
    }

    public ArrayList<Task> getActiveBlockTasks() {
        return this.activeBlockTasks;
    }

    public ArrayList<Task> getCacheBlockTasks() {
        return this.cacheBlockTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TaskManager> clazz = TaskManager.class;
        synchronized (TaskManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void addTask(class_2248 block, class_2338 pos, class_638 world) {
        TaskManager.getInstance().addBlockTask(world, pos, block);
    }

    public static boolean isWorking() {
        return TaskManager.getInstance().isRunning();
    }

    public static void setWorking(boolean working) {
        TaskManager.getInstance().setRunning(working);
    }

    public static void clearTask() {
        TaskManager.getInstance().removeAll();
    }
}

