/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.command.commands;

import com.github.bunnyi116.bedrockminer.APIs;
import com.github.bunnyi116.bedrockminer.BedrockMiner;
import com.github.bunnyi116.bedrockminer.I18n;
import com.github.bunnyi116.bedrockminer.command.CommandBase;
import com.github.bunnyi116.bedrockminer.command.argument.BlockPosArgumentType;
import com.github.bunnyi116.bedrockminer.config.Config;
import com.github.bunnyi116.bedrockminer.config.ConfigManager;
import com.github.bunnyi116.bedrockminer.task.TaskManager;
import com.github.bunnyi116.bedrockminer.task.TaskRegion;
import com.github.bunnyi116.bedrockminer.util.MessageUtils;
import com.github.bunnyi116.bedrockminer.util.StringReaderUtils;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public class TaskCommand
extends CommandBase {
    @Override
    public String getName() {
        return "task";
    }

    @Override
    public void build(LiteralArgumentBuilder<FabricClientCommandSource> builder, class_7157 registryAccess) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"short").then(ClientCommandManager.argument((String)"bool", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean b = BoolArgumentType.getBool((CommandContext)context, (String)"bool");
            if (b) {
                MessageUtils.addMessage(I18n.COMMAND_TASK_SHORT_WAIT_SHORT);
            } else {
                MessageUtils.addMessage(I18n.COMMAND_TASK_SHORT_WAIT_NORMAL);
            }
            Config.getInstance().shortTsk = b;
            Config.getInstance().save();
            return 1;
        })))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"blockPos1", (ArgumentType)BlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"blockPos2", (ArgumentType)BlockPosArgumentType.blockPos()).executes(context -> this.addRegionTask((CommandContext<FabricClientCommandSource>)context, false))))))).then(ClientCommandManager.literal((String)"addToConfig").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"blockPos1", (ArgumentType)BlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"blockPos2", (ArgumentType)BlockPosArgumentType.blockPos()).executes(context -> this.addRegionTask((CommandContext<FabricClientCommandSource>)context, true))))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, suggestionsBuilder) -> {
            StringReader reader = new StringReader(suggestionsBuilder.getInput());
            reader.setCursor(suggestionsBuilder.getStart());
            String input = StringReaderUtils.readUnquotedString(reader);
            for (TaskRegion item : Config.getInstance().ranges) {
                if (!item.name.contains(input)) continue;
                suggestionsBuilder.suggest(StringArgumentType.escapeIfRequired((String)item.name));
            }
            for (TaskRegion item : TaskManager.getInstance().getPendingRegionTasks()) {
                if (!item.name.contains(input)) continue;
                suggestionsBuilder.suggest(StringArgumentType.escapeIfRequired((String)item.name));
            }
            return suggestionsBuilder.buildFuture();
        }).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            @Nullable TaskRegion range = null;
            for (TaskRegion item : Config.getInstance().ranges) {
                if (!item.name.equals(name)) continue;
                range = item;
                break;
            }
            if (range == null) {
                for (TaskRegion item : TaskManager.getInstance().getPendingRegionTasks()) {
                    if (!item.name.equals(name)) continue;
                    range = item;
                    break;
                }
            }
            if (range != null) {
                Config.getInstance().ranges.remove(range);
                Config.getInstance().save();
                MessageUtils.addMessage((class_2561)class_2561.method_43470((String)("\u5df2\u6210\u529f\u5220\u9664: " + name)));
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"clear").executes(context -> {
            APIs.getInstance().getTaskManager().removeBlockTaskAll();
            APIs.getInstance().getTaskManager().removeRegionTaskAll();
            return 1;
        }));
    }

    private int addRegionTask(CommandContext<FabricClientCommandSource> context, boolean isConfig) {
        String name = StringArgumentType.getString(context, (String)"name");
        class_2338 blockPos1 = BlockPosArgumentType.getBlockPos(context, "blockPos1");
        class_2338 blockPos2 = BlockPosArgumentType.getBlockPos(context, "blockPos2");
        boolean b = true;
        if (isConfig) {
            for (TaskRegion item : ConfigManager.getInstance().getConfig().ranges) {
                if (!item.name.equals(name)) continue;
                b = false;
                break;
            }
            if (b) {
                TaskRegion range = new TaskRegion(name, BedrockMiner.world, blockPos1, blockPos2);
                ConfigManager.getInstance().getConfig().ranges.add(range);
                ConfigManager.getInstance().getConfig().save();
                MessageUtils.addMessage((class_2561)class_2561.method_43470((String)("\u5df2\u6210\u529f\u6dfb\u52a0\u5230\u914d\u7f6e\u6587\u4ef6: " + name)));
            }
        } else {
            for (TaskRegion item : TaskManager.getInstance().getPendingRegionTasks()) {
                if (!item.name.equals(name)) continue;
                b = false;
                break;
            }
            if (b) {
                TaskRegion range = new TaskRegion(name, BedrockMiner.world, blockPos1, blockPos2);
                TaskManager.getInstance().getPendingRegionTasks().add(range);
                MessageUtils.addMessage((class_2561)class_2561.method_43470((String)("\u5df2\u6210\u529f\u6dfb\u52a0: " + name)));
            }
        }
        return 1;
    }
}

