/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_746;

public class BlockPosArgumentType
implements ArgumentType<class_2338> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0 0", "~ ~ ~");

    public static BlockPosArgumentType blockPos() {
        return new BlockPosArgumentType();
    }

    public static class_2338 getBlockPos(CommandContext<FabricClientCommandSource> context, String name) {
        return (class_2338)context.getArgument(name, class_2338.class);
    }

    public class_2338 parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        if (reader.canRead()) {
            int x = this.parseCoordinate(reader, 0);
            if (reader.canRead()) {
                int y = this.parseCoordinate(reader, 1);
                if (reader.canRead()) {
                    int z = this.parseCoordinate(reader, 2);
                    return new class_2338(x, y, z);
                }
            }
        }
        reader.setCursor(i);
        throw class_2277.field_10755.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        class_239 hitResult;
        int cursor;
        String remaining = builder.getRemaining();
        StringReader reader = new StringReader(remaining);
        String xString = null;
        String yString = null;
        String zString = null;
        if (reader.canRead() && (reader.peek() == '~' || BlockPosArgumentType.isAllowedInteger(reader.peek()))) {
            cursor = reader.getCursor();
            while (reader.canRead() && reader.peek() != ' ') {
                reader.skip();
            }
            xString = reader.getString().substring(cursor, reader.getCursor());
        }
        reader.skipWhitespace();
        if (reader.canRead() && (reader.peek() == '~' || BlockPosArgumentType.isAllowedInteger(reader.peek()))) {
            cursor = reader.getCursor();
            while (reader.canRead() && reader.peek() != ' ') {
                reader.skip();
            }
            yString = reader.getString().substring(cursor, reader.getCursor());
        }
        reader.skipWhitespace();
        if (reader.canRead() && (reader.peek() == '~' || BlockPosArgumentType.isAllowedInteger(reader.peek()))) {
            cursor = reader.getCursor();
            while (reader.canRead() && reader.peek() != ' ') {
                reader.skip();
            }
            zString = reader.getString().substring(cursor, reader.getCursor());
        }
        if ((hitResult = class_310.method_1551().field_1765) != null && hitResult.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)hitResult;
            class_2338 blockPos = blockHitResult.method_17777();
            if (xString == null && yString == null && zString == null) {
                builder.suggest(blockPos.method_10263());
                builder.suggest(String.format("%s %s", blockPos.method_10263(), blockPos.method_10264()));
                builder.suggest(String.format("%s %s %s", blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()));
            }
            if (xString != null && yString == null && zString == null) {
                builder.suggest(String.format("%s %s", xString, blockPos.method_10264()));
                builder.suggest(String.format("%s %s %s", xString, blockPos.method_10264(), blockPos.method_10260()));
            }
            if (xString != null && yString != null && zString == null) {
                builder.suggest(String.format("%s %s %s", xString, yString, blockPos.method_10260()));
            }
        } else {
            if (xString == null && yString == null && zString == null) {
                builder.suggest("~");
                builder.suggest("~ ~");
                builder.suggest("~ ~ ~");
            }
            if (xString != null && yString == null && zString == null) {
                builder.suggest(String.format("%s ~", xString));
                builder.suggest(String.format("%s ~ ~", xString));
            }
            if (xString != null && yString != null && zString == null) {
                builder.suggest(String.format("%s %s ~", xString, yString));
            }
        }
        return builder.buildFuture();
    }

    private int parseCoordinate(StringReader reader, int type) throws CommandSyntaxException {
        reader.skipWhitespace();
        int i = reader.getCursor();
        if (reader.canRead() && reader.peek() != ' ') {
            if (reader.peek() == '~') {
                reader.skip();
                int offset = 0;
                if (reader.canRead() && BlockPosArgumentType.isAllowedInteger(reader.peek())) {
                    offset = reader.readInt();
                }
                class_746 player = class_310.method_1551().field_1724;
                if (type == 0) {
                    return (player == null ? 0 : player.method_31477()) + offset;
                }
                if (type == 1) {
                    return (player == null ? 0 : player.method_31478()) + offset;
                }
                if (type == 2) {
                    return (player == null ? 0 : player.method_31479()) + offset;
                }
                return 0;
            }
            if (BlockPosArgumentType.isAllowedInteger(reader.peek())) {
                return reader.readInt();
            }
        }
        reader.setCursor(i);
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().create((Object)reader.getRemaining());
    }

    public static boolean isAllowedInteger(char c) {
        return c >= '0' && c <= '9' || c == '-';
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

