/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.command.commands;

import com.github.bunnyi116.bedrockminer.I18n;
import com.github.bunnyi116.bedrockminer.command.CommandBase;
import com.github.bunnyi116.bedrockminer.command.argument.BlockArgument;
import com.github.bunnyi116.bedrockminer.config.Config;
import com.github.bunnyi116.bedrockminer.util.MessageUtils;
import com.github.bunnyi116.bedrockminer.util.block.BlockUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2248;
import net.minecraft.class_2561;

public class BehaviorCommand
extends CommandBase {
    @Override
    public String getName() {
        return "behavior";
    }

    @Override
    public void build(LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        ((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"floor").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"floor", (ArgumentType)IntegerArgumentType.integer()).executes(this::addFloor)))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"floor", (ArgumentType)IntegerArgumentType.integer()).executes(this::removeFloor)))).then(ClientCommandManager.literal((String)"list").executes(this::listFloor)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"blockWhitelist").then(ClientCommandManager.literal((String)"addTask").then(ClientCommandManager.argument((String)"block", (ArgumentType)new BlockArgument(this::filterBlockWhitelist)).executes(this::addBlockWhitelist)))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"block", (ArgumentType)new BlockArgument(this::showBlockWhitelist)).executes(this::removeBlockWhitelist))));
    }

    private int listFloor(CommandContext<FabricClientCommandSource> context) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Config.getInstance().floorsBlacklist.size(); ++i) {
            Integer floor = Config.getInstance().floorsBlacklist.get(i);
            if (i == Config.getInstance().floorsBlacklist.size() - 1) {
                sb.append(floor);
                continue;
            }
            sb.append(floor).append(",");
        }
        MessageUtils.addMessage((class_2561)class_2561.method_43470((String)I18n.FLOOR_BLACK_LIST_SHOW.getString().replace("%listFloor%", sb.toString())));
        return 1;
    }

    private int addFloor(CommandContext<FabricClientCommandSource> context) {
        int floor = IntegerArgumentType.getInteger(context, (String)"floor");
        if (!Config.getInstance().floorsBlacklist.contains(floor)) {
            Config.getInstance().floorsBlacklist.add(floor);
            Config.getInstance().save();
        }
        MessageUtils.addMessage((class_2561)class_2561.method_43470((String)I18n.FLOOR_BLACK_LIST_ADD.getString().replace("%count%", String.valueOf(floor))));
        return 1;
    }

    private int removeFloor(CommandContext<FabricClientCommandSource> context) {
        int floor = IntegerArgumentType.getInteger(context, (String)"floor");
        if (Config.getInstance().floorsBlacklist.contains(floor)) {
            Config.getInstance().floorsBlacklist.remove((Object)floor);
            Config.getInstance().save();
        }
        MessageUtils.addMessage((class_2561)class_2561.method_43470((String)I18n.FLOOR_BLACK_LIST_REMOVE.getString().replace("%count%", String.valueOf(floor))));
        return 1;
    }

    private int addBlockWhitelist(CommandContext<FabricClientCommandSource> context) {
        class_2248 block = BlockArgument.getBlock(context, "block");
        String blockId = BlockUtils.getIdentifierString(block);
        if (!Config.getInstance().blockWhitelist.contains(blockId)) {
            Config.getInstance().blockWhitelist.add(blockId);
            Config.getInstance().save();
            this.sendChat(I18n.COMMAND_BLOCK_WHITELIST_ADD, block);
        }
        return 1;
    }

    private int removeBlockWhitelist(CommandContext<FabricClientCommandSource> context) {
        class_2248 block = BlockArgument.getBlock(context, "block");
        String blockId = BlockUtils.getIdentifierString(block);
        if (Config.getInstance().blockWhitelist.contains(blockId)) {
            Config.getInstance().blockWhitelist.remove(blockId);
            Config.getInstance().save();
            this.sendChat(I18n.COMMAND_BLOCK_WHITELIST_REMOVE, block);
        }
        return 1;
    }

    private boolean isFilterBlock(class_2248 block) {
        return block.method_9564().method_26215() || BlockUtils.isReplaceable(block.method_9564());
    }

    private Boolean filterBlockWhitelist(class_2248 block) {
        if (this.isFilterBlock(block)) {
            return true;
        }
        return Config.getInstance().blockWhitelist.contains(BlockUtils.getIdentifierString(block));
    }

    private Boolean showBlockWhitelist(class_2248 block) {
        return !Config.getInstance().blockWhitelist.contains(BlockUtils.getIdentifierString(block));
    }

    private void sendChat(class_2561 text, class_2248 block) {
        String msg = text.getString().replace("#blockName#", BlockUtils.getBlockName(block));
        MessageUtils.addMessage((class_2561)class_2561.method_43470((String)msg));
    }
}

