/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.command.argument.operator;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public enum Operator {
    GREATER_THAN(">"),
    GREATER_THAN_OR_EQUAL(">="),
    EQUAL("=="),
    LESS_THAN_OR_EQUAL("<="),
    LESS_THAN("<");

    private final String symbol;

    private Operator(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Nullable
    public static Operator fromString(String symbol) {
        for (Operator op : Operator.values()) {
            if (!op.getSymbol().equals(symbol)) continue;
            return op;
        }
        return null;
    }

    public static List<String> getStringValues() {
        ArrayList<String> list = new ArrayList<String>();
        for (Operator operator : Operator.values()) {
            list.add(operator.symbol);
        }
        return list;
    }
}

