/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.config;

import com.github.bunnyi116.bedrockminer.Debug;
import com.github.bunnyi116.bedrockminer.config.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

public class ConfigManager {
    @Nullable
    private static volatile ConfigManager INSTANCE;
    public static final File CONFIG_DIR;
    public static final File MOD_FILE;
    @Nullable
    private volatile Config CONFIG;

    public Config loadConfig() {
        Config config = ConfigManager.load(MOD_FILE, Config.class);
        if (config == null) {
            config = new Config();
        }
        this.CONFIG = config;
        return config;
    }

    public void saveConfig() {
        ConfigManager.save(MOD_FILE, this.getConfig());
    }

    @Nullable
    public static <T> T load(File file, Class<T> clazz) {
        Object config = null;
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(file);){
            config = gson.fromJson((Reader)reader, clazz);
            Debug.alwaysWrite("\u5df2\u6210\u529f\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6");
        }
        catch (Exception e) {
            if (file.exists()) {
                if (file.delete()) {
                    Debug.alwaysWrite("\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e,\u5df2\u6210\u529f\u5220\u9664\u914d\u7f6e\u6587\u4ef6");
                } else {
                    Debug.alwaysWrite("\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e,\u5220\u9664\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
                }
            }
            Debug.alwaysWrite("\u627e\u4e0d\u5230\u914d\u7f6e\u6587\u4ef6");
        }
        try {
            if (config == null) {
                Debug.alwaysWrite("\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e");
                config = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            ConfigManager.save(file, config);
            return (T)config;
        }
        catch (Exception e) {
            Debug.alwaysWrite("\u65e0\u6cd5\u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e");
            return null;
        }
    }

    public static <T> void save(File file, T instance) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(instance, (Appendable)writer);
        }
        catch (IOException e) {
            Debug.alwaysWrite("\u65e0\u6cd5\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Config getConfig() {
        if (this.CONFIG == null) {
            Config config;
            Class<ConfigManager> clazz = ConfigManager.class;
            // MONITORENTER : com.github.bunnyi116.bedrockminer.config.ConfigManager.class
            if (this.CONFIG == null && (config = ConfigManager.load(MOD_FILE, Config.class)) != null) {
                this.CONFIG = config;
            }
            // MONITOREXIT : clazz
        }
        if (this.CONFIG != null) return this.CONFIG;
        this.CONFIG = new Config();
        return this.CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    static {
        CONFIG_DIR = FabricLoader.getInstance().getConfigDir().toFile();
        MOD_FILE = new File(CONFIG_DIR, "bedrockminer.json");
    }
}

