/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.task;

import com.github.bunnyi116.bedrockminer.BedrockMiner;
import com.github.bunnyi116.bedrockminer.Debug;
import com.github.bunnyi116.bedrockminer.I18n;
import com.github.bunnyi116.bedrockminer.config.Config;
import com.github.bunnyi116.bedrockminer.task.TaskManager;
import com.github.bunnyi116.bedrockminer.task.TaskPlan;
import com.github.bunnyi116.bedrockminer.task.TaskPlanItem;
import com.github.bunnyi116.bedrockminer.task.TaskPlanTools;
import com.github.bunnyi116.bedrockminer.task.TaskState;
import com.github.bunnyi116.bedrockminer.util.MessageUtils;
import com.github.bunnyi116.bedrockminer.util.block.BlockUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerInteractionUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerInventoryUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerLookUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerUtils;
import com.google.common.collect.Queues;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2458;
import net.minecraft.class_2459;
import net.minecraft.class_2561;
import net.minecraft.class_2665;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class Task {
    public final class_638 world;
    public final class_2248 block;
    public final class_2338 pos;
    private TaskState currentState;
    private TaskState lastState;
    @Nullable
    private TaskState nextState;
    public final List<TaskPlan> planItems;
    @Nullable
    public TaskPlan planItem;
    public final Queue<class_2338> recycledQueue;
    public boolean executeModify;
    private int tickTotalCount;
    private int tickInternalCount;
    private int ticksTotalMax;
    private int ticksTimeoutMax;
    private int tickWaitMax;
    public int retryCount;
    public int retryCountMax;
    public int active;
    public boolean retry;
    public boolean executed;
    public boolean recycled;
    public boolean timeout;
    private boolean tickOccupied;
    private boolean requestPickaxe;

    public Task(class_638 world, class_2248 block, class_2338 pos) {
        this.world = world;
        this.block = block;
        this.pos = pos;
        this.planItems = TaskPlanTools.findAllPossible(pos);
        this.recycledQueue = Queues.newConcurrentLinkedQueue();
        this.init();
    }

    private void tickOccupied() {
        this.tickOccupied = true;
    }

    public boolean canInteractWithBlockAt() {
        if (this.world == BedrockMiner.world && PlayerUtils.canInteractWithBlockAt(this.pos, 1.0)) {
            if (this.planItem != null) {
                return this.planItem.canInteractWithBlockAt();
            }
            return true;
        }
        return false;
    }

    private void setWait(@Nullable TaskState nextState, int tickWaitMax) {
        this.nextState = nextState;
        this.tickWaitMax = Math.max(tickWaitMax, 1);
        this.currentState = TaskState.WAIT_CUSTOM;
        this.tickOccupied();
    }

    private void setModifyLook(TaskPlanItem blockInfo) {
        if (blockInfo != null) {
            this.debug("\u4fee\u6539\u89c6\u89d2", new Object[0]);
            this.setModifyLook(blockInfo.facing);
            blockInfo.modify = true;
            this.tickOccupied();
        }
    }

    private void setModifyLook(class_2350 facing) {
        PlayerLookUtils.set(facing, this);
        this.tickOccupied();
    }

    private void resetModifyLook() {
        if (PlayerLookUtils.isModify()) {
            PlayerLookUtils.reset();
        }
    }

    public void tick() {
        this.debug("\u5f00\u59cb", new Object[0]);
        this.tickOccupied = false;
        if (this.currentState == TaskState.COMPLETE) {
            this.debug("\u4efb\u52a1\u5df2\u5b8c\u6210", new Object[0]);
        } else {
            this.lastState = this.currentState;
            if (this.tickTotalCount >= this.ticksTotalMax) {
                this.currentState = TaskState.COMPLETE;
                this.tickOccupied();
            }
            if (!this.timeout && this.tickTotalCount >= this.ticksTimeoutMax) {
                this.timeout = true;
                this.currentState = TaskState.TIMEOUT;
            }
            this.tickInternalCount = 0;
            while (this.tickInternalCount < 10) {
                this.lastState = this.currentState;
                switch (this.currentState) {
                    case INITIALIZE: {
                        this.init();
                        break;
                    }
                    case WAIT_GAME_UPDATE: {
                        this.updateStates();
                        break;
                    }
                    case WAIT_CUSTOM: {
                        this.waitCustom();
                        break;
                    }
                    case FIND: {
                        this.find();
                        break;
                    }
                    case PLACE_PISTON: {
                        this.placePiston();
                        break;
                    }
                    case PLACE_REDSTONE_TORCH: {
                        this.placeRedstoneTorch();
                        break;
                    }
                    case PLACE_SLIME_BLOCK: {
                        this.placeSlimeBlock();
                        break;
                    }
                    case EXECUTE: {
                        this.execute();
                        break;
                    }
                    case RETRY: {
                        this.retry = true;
                        if (!this.recycledQueue.isEmpty()) {
                            this.currentState = TaskState.RECYCLED_ITEMS;
                            return;
                        }
                        if (this.retryCount < this.retryCountMax) {
                            ++this.retryCount;
                            this.debug("\u4efb\u52a1\u7269\u54c1\u56de\u6536\u5df2\u5b8c\u6210, \u8d85\u65f6\u91cd\u8bd5: %s", this.retryCount);
                            this.currentState = TaskState.INITIALIZE;
                            break;
                        }
                        this.currentState = TaskState.COMPLETE;
                        this.tickOccupied();
                        break;
                    }
                    case TIMEOUT: {
                        this.debug("\u4efb\u52a1\u5df2\u8d85\u65f6", new Object[0]);
                        this.currentState = TaskState.RETRY;
                        break;
                    }
                    case FAIL: {
                        this.debug("\u4efb\u52a1\u5df2\u5931\u8d25", new Object[0]);
                        this.currentState = TaskState.RETRY;
                        break;
                    }
                    case RECYCLED_ITEMS: {
                        this.recycledItems();
                        break;
                    }
                    case COMPLETE: {
                        this.debug("\u4efb\u52a1\u5df2\u5b8c\u6210", new Object[0]);
                    }
                }
                if (this.lastState == this.currentState) {
                    this.debug("\u72b6\u6001\u4e00\u81f4\uff0c\u65e0\u9700\u5185\u90e8\u5faa\u73af", new Object[0]);
                    break;
                }
                if (this.tickOccupied) {
                    this.debug("\u72ec\u5360TICK\u8fd0\u884c", new Object[0]);
                    break;
                }
                ++this.tickInternalCount;
            }
        }
        this.debug("\u7ed3\u675f\r\n", new Object[0]);
        ++this.tickTotalCount;
    }

    private void placeSlimeBlock() {
        if (this.planItem == null) {
            this.currentState = TaskState.FIND;
            return;
        }
        PlayerInteractionUtils.placement(this.planItem.slimeBlock.pos, this.planItem.slimeBlock.facing, class_1802.field_8828);
        this.addRecycled(this.planItem.slimeBlock.pos);
        this.resetModifyLook();
        this.currentState = TaskState.WAIT_GAME_UPDATE;
    }

    private void placeRedstoneTorch() {
        if (this.planItem == null) {
            this.currentState = TaskState.FIND;
            return;
        }
        this.debug("\u7ea2\u77f3\u706b\u628a", new Object[0]);
        class_2680 placeBlockState = this.planItem.redstoneTorch.facing.method_10166().method_10178() ? class_2246.field_10523.method_9564() : (class_2680)class_2246.field_10301.method_9564().method_11657((class_2769)class_2458.field_11443, (Comparable)this.planItem.redstoneTorch.facing);
        if (PlayerInteractionUtils.canPlace(this.world, this.planItem.redstoneTorch.pos, placeBlockState)) {
            if (this.planItem.redstoneTorch.isNeedModify() && !this.planItem.redstoneTorch.modify) {
                this.setModifyLook(this.planItem.redstoneTorch);
                return;
            }
            PlayerInteractionUtils.placement(this.planItem.redstoneTorch.pos, this.planItem.redstoneTorch.facing, class_1802.field_8530);
            class_2680 blockState = this.world.method_8320(this.planItem.redstoneTorch.pos);
            if (this.planItem.redstoneTorch.facing.method_10166().method_10179() && blockState.method_26204() instanceof class_2458) {
                this.world.method_8652(this.planItem.redstoneTorch.pos, (class_2680)blockState.method_11657((class_2769)class_2458.field_11443, (Comparable)this.planItem.redstoneTorch.facing), 3);
            }
            this.addRecycled(this.planItem.redstoneTorch.pos);
            if (Config.getInstance().shortTsk) {
                this.currentState = TaskState.WAIT_GAME_UPDATE;
                this.tickOccupied();
            } else {
                this.setWait(TaskState.WAIT_GAME_UPDATE, 3);
            }
            this.resetModifyLook();
        }
    }

    private void placePiston() {
        class_2338[] nearbyRedstoneTorch;
        if (this.planItem == null) {
            this.currentState = TaskState.FIND;
            return;
        }
        for (class_2338 pos : nearbyRedstoneTorch = TaskPlanTools.findPistonNearbyRedstoneTorch(this.planItem.piston.pos, this.world)) {
            if (!(this.world.method_8320(pos).method_26204() instanceof class_2459)) continue;
            PlayerInteractionUtils.updateBlockBreakingProgress(pos);
        }
        this.debug("\u653e\u7f6e\u6d3b\u585e", new Object[0]);
        class_2680 placeBlockState = (class_2680)class_2246.field_10560.method_9564().method_11657((class_2769)class_2665.field_10927, (Comparable)this.planItem.piston.facing);
        if (PlayerInteractionUtils.canPlace(this.world, this.planItem.piston.pos, placeBlockState)) {
            if (this.planItem.piston.isNeedModify() && !this.planItem.piston.modify) {
                this.setModifyLook(this.planItem.piston);
                return;
            }
            PlayerInteractionUtils.placement(this.planItem.piston.pos, this.planItem.piston.facing, class_1802.field_8249, class_1802.field_8105);
            class_2680 blockState = this.world.method_8320(this.planItem.piston.pos);
            if (blockState.method_26204() instanceof class_2665) {
                this.world.method_8652(this.planItem.piston.pos, (class_2680)blockState.method_11657((class_2769)class_2665.field_10927, (Comparable)this.planItem.piston.facing), 3);
            }
            this.addRecycled(this.planItem.piston.pos);
            if (Config.getInstance().shortTsk) {
                this.currentState = TaskState.WAIT_GAME_UPDATE;
                this.tickOccupied();
            } else {
                this.setWait(TaskState.WAIT_GAME_UPDATE, 3);
            }
            this.resetModifyLook();
        } else {
            this.planItem = null;
            this.currentState = TaskState.FIND;
        }
    }

    private void find() {
        if (this.planItem == null) {
            this.debug("\u67e5\u627e\u65b9\u6848", new Object[0]);
            for (TaskPlan item : this.planItems) {
                class_2680 slimeBlockState = this.world.method_8320(item.slimeBlock.pos);
                item.slimeBlock.level = item.canInteractWithBlockAt() ? --item.slimeBlock.level : (item.slimeBlock.level += 1000);
                if (PlayerInventoryUtils.getInventoryItemCount(class_1802.field_8828) < 1) {
                    item.slimeBlock.level += 1000;
                    continue;
                }
                if (BlockUtils.isReplaceable(slimeBlockState)) {
                    ++item.slimeBlock.level;
                    continue;
                }
                if (BlockUtils.sideCoversSmallSquare(item.slimeBlock.pos, item.slimeBlock.facing)) {
                    --item.slimeBlock.level;
                    continue;
                }
                item.slimeBlock.level += 1000;
            }
            this.planItems.sort(Comparator.comparingInt(scheme -> scheme.level + scheme.piston.level + scheme.redstoneTorch.level + scheme.slimeBlock.level));
            for (TaskPlan item : this.planItems) {
                class_2680 redstoneTorchState;
                if (!item.isWorldValid()) continue;
                class_2338 pistonPos = item.piston.pos;
                class_2350 pistonFacing = item.piston.facing;
                class_2338 pistonHeadPos = pistonPos.method_10093(pistonFacing);
                class_2680 pistonState = this.world.method_8320(pistonPos);
                class_2680 pistonHeadState = this.world.method_8320(pistonHeadPos);
                class_2680 pistonDefaultState = (class_2680)class_2246.field_10560.method_9564().method_11657((class_2769)class_2665.field_10927, (Comparable)pistonFacing);
                class_2680 pistonHeadDefaultState = (class_2680)class_2246.field_10379.method_9564().method_11657((class_2769)class_2671.field_10927, (Comparable)pistonFacing);
                if ((!PlayerInteractionUtils.canPlace(this.world, pistonPos, pistonDefaultState) || !PlayerInteractionUtils.canPlace(this.world, pistonHeadPos, pistonHeadDefaultState)) && (!pistonState.method_27852(class_2246.field_10560) || !pistonHeadState.method_27852(class_2246.field_10379)) || !BlockUtils.isReplaceable(redstoneTorchState = this.world.method_8320(item.redstoneTorch.pos)) && !(redstoneTorchState.method_26204() instanceof class_2459) && !(redstoneTorchState.method_26204() instanceof class_2458) || this.world.method_8316(item.redstoneTorch.pos).method_15767(class_3486.field_15517) || !PlayerInteractionUtils.canPlace(this.world, item.slimeBlock.pos, class_2246.field_10030.method_9564()) && !BlockUtils.sideCoversSmallSquare(item.slimeBlock.pos, item.slimeBlock.facing) || item.redstoneTorch.type == 1 && !this.world.method_8320(this.pos).method_26212((class_1922)this.world, this.pos) || BlockUtils.isReplaceable(this.world.method_8320(item.slimeBlock.pos)) && PlayerInventoryUtils.getInventoryItemCount(class_1802.field_8828) < 1) continue;
                boolean b = true;
                if (!TaskManager.getInstance().getActiveBlockTasks().isEmpty()) {
                    for (Task task : TaskManager.getInstance().getActiveBlockTasks()) {
                        if (task == null || task.planItem == null) continue;
                        if (this.pos.equals((Object)task.planItem.piston.pos)) {
                            b = false;
                            break;
                        }
                        if (item.piston.pos.equals((Object)task.planItem.piston.pos)) {
                            b = false;
                            break;
                        }
                        if (item.piston.pos.equals((Object)task.planItem.redstoneTorch.pos)) {
                            b = false;
                            break;
                        }
                        for (class_2350 direction : class_2350.values()) {
                            if (!item.piston.pos.equals((Object)task.planItem.redstoneTorch.pos.method_10093(direction))) continue;
                            b = false;
                            break;
                        }
                        if (item.piston.pos.equals((Object)task.planItem.slimeBlock.pos)) {
                            b = false;
                            break;
                        }
                        if (item.redstoneTorch.pos.equals((Object)task.planItem.piston.pos)) {
                            b = false;
                            break;
                        }
                        for (class_2350 direction : class_2350.values()) {
                            if (!item.redstoneTorch.pos.equals((Object)task.planItem.piston.pos.method_10093(direction))) continue;
                            b = false;
                            break;
                        }
                        if (item.redstoneTorch.pos.equals((Object)task.planItem.redstoneTorch.pos)) {
                            b = false;
                            break;
                        }
                        if (item.redstoneTorch.pos.equals((Object)task.planItem.slimeBlock.pos)) {
                            b = false;
                            break;
                        }
                        if (item.slimeBlock.pos.equals((Object)task.planItem.piston.pos)) {
                            b = false;
                            break;
                        }
                        if (item.slimeBlock.pos.equals((Object)task.planItem.redstoneTorch.pos)) {
                            b = false;
                            break;
                        }
                        if (item.piston.pos.method_10093(item.piston.facing).equals((Object)task.planItem.piston.pos)) {
                            b = false;
                            break;
                        }
                        if (item.piston.pos.method_10093(item.piston.facing).equals((Object)task.planItem.redstoneTorch.pos)) {
                            b = false;
                            break;
                        }
                        if (!item.piston.pos.method_10093(item.piston.facing).equals((Object)task.planItem.slimeBlock.pos)) continue;
                        b = false;
                        break;
                    }
                }
                if (TaskManager.getInstance().isBedrockMinerFeatureEnable() && item.redstoneTorch.type == 1 || !b) continue;
                this.planItem = item;
                break;
            }
        }
        if (this.planItem == null) {
            this.currentState = TaskState.FAIL;
            MessageUtils.setOverlayMessage((class_2561)class_2561.method_43470((String)I18n.HANDLE_SEEK.getString().replace("%BlockPos%", this.pos.method_23854())));
        } else {
            this.debug("\u76ee\u6807: %s", this.pos);
            this.debug("\u65b9\u6848: %s", this.planItem.direction);
            this.debug("\u6d3b\u585e: %s", this.planItem.piston);
            this.debug("\u5e95\u5ea7: %s", this.planItem.slimeBlock);
            this.debug("\u7ea2\u77f3\u706b\u628a: %s", this.planItem.redstoneTorch);
            this.currentState = TaskState.WAIT_GAME_UPDATE;
        }
    }

    private void recycledItems() {
        if (!this.recycledQueue.isEmpty()) {
            class_2338 blockPos = this.recycledQueue.peek();
            if (blockPos == null) {
                this.recycledQueue.remove();
                return;
            }
            class_2680 blockState = this.world.method_8320(blockPos);
            this.debug("\u4efb\u52a1\u7269\u54c1\u6b63\u5728\u56de\u6536: (%s) --> %s", blockPos.method_23854(), blockState.method_26204().method_9518().getString());
            if (blockState.method_26204().method_36555() < 0.0f) {
                this.recycledQueue.remove();
                return;
            }
            boolean instant = PlayerUtils.canInstantlyMineBlock(blockState);
            if (!instant) {
                this.requestPickaxe = true;
                PlayerInventoryUtils.autoSwitch(blockState);
            } else {
                this.requestPickaxe = false;
            }
            PlayerInteractionUtils.updateBlockBreakingProgress(blockPos, false);
            if (BlockUtils.isReplaceable(blockState)) {
                this.recycledQueue.remove();
            }
            if (!instant && !this.recycledQueue.isEmpty()) {
                this.tickOccupied();
            }
        } else {
            this.debug("\u4efb\u52a1\u7269\u54c1\u56de\u6536\u5df2\u5b8c\u6210", new Object[0]);
            this.currentState = this.retry ? TaskState.RETRY : TaskState.COMPLETE;
            this.tickOccupied();
        }
    }

    private void execute() {
        class_2338[] nearbyRedstoneTorch;
        if (this.executed || BedrockMiner.player == null || this.planItem == null) {
            return;
        }
        this.updateStates();
        if (this.currentState != TaskState.EXECUTE) {
            this.debug("\u6761\u4ef6\u4e0d\u5145\u8db3\uff0c\u7b49\u5f85\u66f4\u65b0", new Object[0]);
            this.currentState = TaskState.WAIT_GAME_UPDATE;
            this.tickOccupied();
            return;
        }
        if (!this.executeModify && this.planItem.direction.method_10166().method_10179()) {
            this.setModifyLook(this.planItem.direction.method_10153());
            this.executeModify = true;
            return;
        }
        if (!PlayerUtils.canInstantlyMineBlock(this.world.method_8320(this.planItem.piston.pos))) {
            PlayerInventoryUtils.autoSwitch(this.world.method_8320(this.planItem.piston.pos));
            this.requestPickaxe = true;
            this.setWait(TaskState.EXECUTE, 1);
            return;
        }
        this.requestPickaxe = false;
        for (class_2338 pos : nearbyRedstoneTorch = TaskPlanTools.findPistonNearbyRedstoneTorch(this.planItem.piston.pos, this.world)) {
            if (!(this.world.method_8320(pos).method_26204() instanceof class_2459)) continue;
            PlayerInteractionUtils.updateBlockBreakingProgress(pos);
        }
        if (this.world.method_8320(this.planItem.redstoneTorch.pos).method_26204() instanceof class_2459) {
            PlayerInteractionUtils.updateBlockBreakingProgress(this.planItem.redstoneTorch.pos);
        }
        PlayerInteractionUtils.updateBlockBreakingProgress(this.planItem.piston.pos);
        PlayerInteractionUtils.placement(this.planItem.piston.pos, this.planItem.direction.method_10153(), class_1802.field_8249, class_1802.field_8105);
        this.addRecycled(this.planItem.piston.pos);
        if (this.executeModify) {
            this.resetModifyLook();
        }
        this.requestPickaxe = false;
        this.executed = true;
        this.tickOccupied();
        this.currentState = TaskState.WAIT_GAME_UPDATE;
    }

    private void waitCustom() {
        if (--this.tickWaitMax <= 0) {
            this.currentState = this.nextState == null ? TaskState.WAIT_GAME_UPDATE : this.nextState;
            this.tickWaitMax = 0;
            this.debug("\u7b49\u5f85\u5df2\u7ed3\u675f, \u72b6\u6001\u8bbe\u7f6e\u4e3a: %s", new Object[]{this.currentState});
        } else {
            ++this.ticksTotalMax;
            ++this.ticksTimeoutMax;
            this.tickOccupied();
            this.debug("\u5269\u4f59\u7b49\u5f85TICK: %s", this.tickWaitMax);
        }
    }

    private void updateStates() {
        if (!this.world.method_8320(this.pos).method_27852(this.block)) {
            this.currentState = TaskState.RECYCLED_ITEMS;
            this.debugUpdateStates("\u76ee\u6807\u4e0d\u5b58\u5728", new Object[0]);
            this.tickOccupied();
            return;
        }
        if (this.planItem == null) {
            this.currentState = TaskState.FIND;
            this.debugUpdateStates("\u6ca1\u6709\u6b63\u5728\u6267\u884c\u7684\u653e\u7f6e\u65b9\u6848, \u51c6\u5907\u67e5\u627e\u53ef\u6267\u884c\u65b9\u6848", new Object[0]);
            return;
        }
        if (this.world.method_8320(this.planItem.piston.pos).method_27852(class_2246.field_10008)) {
            this.debugUpdateStates("\u6d3b\u585e\u6b63\u5728\u79fb\u52a8", new Object[0]);
            this.tickOccupied();
            return;
        }
        if (!this.executed) {
            this.debugUpdateStates("\u4efb\u52a1\u672a\u6267\u884c\u8fc7", new Object[0]);
            if (!this.canInteractWithBlockAt()) {
                this.debugUpdateStates("\u5f53\u524d\u653e\u7f6e\u65b9\u6848\u4e0d\u5728\u4ea4\u4e92\u8303\u56f4\u5185, \u51c6\u5907\u91cd\u65b0\u9009\u62e9\u4efb\u52a1", new Object[0]);
                this.currentState = TaskState.FIND;
                this.tickOccupied();
                return;
            }
            if (BlockUtils.isReplaceable(this.world.method_8320(this.planItem.piston.pos))) {
                this.debugUpdateStates("[%s] [%s] \u6d3b\u585e\u672a\u653e\u7f6e\u4e14\u8be5\u4f4d\u7f6e\u53ef\u653e\u7f6e\u7269\u54c1,\u8bbe\u7f6e\u653e\u7f6e\u72b6\u6001", this.planItem.piston.pos.method_23854(), this.planItem.piston.facing);
                this.currentState = TaskState.PLACE_PISTON;
                return;
            }
            class_2338 pistonHeadPos = this.planItem.piston.pos.method_10093(this.planItem.piston.facing);
            if (this.world.method_8320(this.planItem.piston.pos).method_26204() instanceof class_2665 && !this.world.method_8320(this.planItem.piston.pos).method_28498((class_2769)class_2665.field_12191) && this.world.method_8320(pistonHeadPos).method_26204() instanceof class_2671) {
                return;
            }
            if (BlockUtils.isReplaceable(this.world.method_8320(this.planItem.slimeBlock.pos))) {
                this.debugUpdateStates("[%s] [%s] \u5e95\u5ea7\u672a\u653e\u7f6e\u4e14\u8be5\u4f4d\u7f6e\u53ef\u653e\u7f6e\u7269\u54c1,\u8bbe\u7f6e\u653e\u7f6e\u72b6\u6001", this.planItem.slimeBlock.pos.method_23854(), this.planItem.slimeBlock.facing);
                this.currentState = TaskState.PLACE_SLIME_BLOCK;
                return;
            }
            if (!BlockUtils.sideCoversSmallSquare(this.planItem.slimeBlock.pos, this.planItem.slimeBlock.facing)) {
                this.debugUpdateStates("[%s] [%s] \u5e95\u5ea7\u5df2\u653e\u7f6e, \u4f46\u4e0d\u662f\u5b8c\u6574\u7684\u65b9\u5757", this.planItem.slimeBlock.pos.method_23854(), this.planItem.slimeBlock.facing);
                this.currentState = TaskState.FAIL;
                return;
            }
            if (BlockUtils.isReplaceable(this.world.method_8320(this.planItem.redstoneTorch.pos))) {
                this.debugUpdateStates("[%s] [%s] \u7ea2\u77f3\u706b\u628a\u672a\u653e\u7f6e\u4e14\u8be5\u4f4d\u7f6e\u53ef\u653e\u7f6e\u7269\u54c1,\u8bbe\u7f6e\u653e\u7f6e\u72b6\u6001", this.planItem.redstoneTorch.pos.method_23854(), this.planItem.redstoneTorch.facing);
                this.currentState = TaskState.PLACE_REDSTONE_TORCH;
                return;
            }
            if (this.world.method_8320(this.planItem.piston.pos).method_26204() instanceof class_2665 && this.world.method_8320(this.planItem.piston.pos).method_28498((class_2769)class_2665.field_12191)) {
                this.debugUpdateStates("[%s] [%s] \u6761\u4ef6\u5df2\u5145\u8db3, \u51c6\u5907\u5f00\u59cb\u5c1d\u8bd5", this.planItem.piston.pos.method_23854(), this.planItem.piston.facing);
                this.currentState = TaskState.EXECUTE;
                return;
            }
            this.debugUpdateStates("\uff1f\uff1f\uff1f", new Object[0]);
            this.tickOccupied();
        }
    }

    private void init() {
        for (class_2350 direction : class_2350.values()) {
            class_2680 pistonUpState;
            class_2338 pos1 = this.pos.method_10093(direction);
            class_2338 pos2 = pos1.method_10084();
            class_2680 pistonState = this.world.method_8320(pos1);
            if (pistonState.method_26204() instanceof class_2665 && PlayerUtils.canInstantlyMineBlock(pistonState)) {
                if (!TaskManager.getInstance().getActiveBlockTasks().isEmpty()) {
                    for (Task task : TaskManager.getInstance().getActiveBlockTasks()) {
                        if (task == null || task.planItem == null || !pos1.equals((Object)task.planItem.piston.pos)) continue;
                        return;
                    }
                }
                PlayerInteractionUtils.updateBlockBreakingProgress(pos1, false);
            }
            if (!((pistonUpState = this.world.method_8320(pos2)).method_26204() instanceof class_2665) || !PlayerUtils.canInstantlyMineBlock(pistonUpState)) continue;
            if (!TaskManager.getInstance().getActiveBlockTasks().isEmpty()) {
                for (Task task : TaskManager.getInstance().getActiveBlockTasks()) {
                    if (task == null || task.planItem == null || !pos2.equals((Object)task.planItem.piston.pos)) continue;
                    return;
                }
            }
            PlayerInteractionUtils.updateBlockBreakingProgress(pos2, false);
        }
        if (TaskManager.getInstance().isBedrockMinerFeatureEnable()) {
            this.retryCountMax = 1;
        }
        this.nextState = null;
        this.tickTotalCount = 0;
        this.ticksTotalMax = 100;
        this.ticksTimeoutMax = 25;
        this.tickWaitMax = 0;
        this.planItem = null;
        this.recycledQueue.clear();
        this.executed = false;
        this.requestPickaxe = false;
        this.recycled = false;
        this.timeout = false;
        this.currentState = TaskState.WAIT_GAME_UPDATE;
        this.retry = false;
        this.find();
    }

    private void debug(String var1, Object ... var2) {
        Debug.write("[{}/{}] [{}:{}/{}] [{} -> {}] {}", new Object[]{this.retryCount, this.retryCountMax, this.tickTotalCount, this.tickInternalCount, this.ticksTotalMax, this.lastState, this.currentState, String.format(var1, var2)});
    }

    private void debugUpdateStates(String var1, Object ... var2) {
        Debug.write("[{}/{}] [{}:{}/{}] [{} -> {}] [\u72b6\u6001\u66f4\u65b0] {}", new Object[]{this.retryCount, this.retryCountMax, this.tickTotalCount, this.tickInternalCount, this.ticksTotalMax, this.lastState, this.currentState, String.format(var1, var2)});
    }

    private void addRecycled(class_2338 pos) {
        if (!this.recycledQueue.contains(pos)) {
            this.recycledQueue.add(pos);
        }
    }

    public boolean isRequestPickaxe() {
        return this.requestPickaxe;
    }

    public boolean isComplete() {
        return this.currentState == TaskState.COMPLETE || this.tickTotalCount >= this.ticksTotalMax;
    }

    public TaskState getCurrentState() {
        return this.currentState;
    }

    public boolean isNeedModify() {
        if (this.planItem != null) {
            return this.planItem.piston.isNeedModify() || this.planItem.redstoneTorch.isNeedModify();
        }
        return false;
    }
}

