/*
 * Decompiled with CFR 0.152.
 */
package com.hbm;

import com.hbm.HBMsNTM;
import com.hbm.config.FalloutConfigJSON;
import com.hbm.config.MainConfig;
import com.hbm.entity.ModEntities;
import com.hbm.entity.mob.CreeperNuclear;
import com.hbm.entity.mob.Duck;
import com.hbm.handler.EntityEffectHandler;
import com.hbm.handler.HTTPHandler;
import com.hbm.hazard.HazardRegistry;
import com.hbm.hazard.HazardSystem;
import com.hbm.inventory.ModMenus;
import com.hbm.inventory.gui.GUICrateIron;
import com.hbm.lib.ModCommands;
import com.hbm.util.DamageResistanceHandler;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="hbmsntm")
public class CommonEvents {
    public static File configDir;
    public static File configHbmDir;
    public static int polaroidID;
    public static int generalOverride;

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        configDir = FMLPaths.CONFIGDIR.get().toFile();
        configHbmDir = new File(configDir, "hbmConfig");
        if (!configHbmDir.exists()) {
            configHbmDir.mkdirs();
        }
        HBMsNTM.LOGGER.info("Let us celebrate the fact that the logger finally works again!");
        HTTPHandler.loadStats();
        FalloutConfigJSON.initialize();
        FalloutConfigJSON.initDefault();
        DamageResistanceHandler.init();
        HazardRegistry.registerItems();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().level().isClientSide && ((Boolean)MainConfig.COMMON.ENABLE_MOTD.get()).booleanValue()) {
            Player player = event.getEntity();
            player.sendSystemMessage((Component)Component.literal((String)"Loaded world with Hbm's Nuclear Tech Mod 0.0.4 ALPHA (5503) for Minecraft 1.21.1!"));
            if (HTTPHandler.newVersion) {
                player.sendSystemMessage((Component)Component.literal((String)("New version " + HTTPHandler.versionNumber + " is available! Click ")).withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"[here]").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/ohiomannnn/HBMsNTM-NEO-EDITION/releases")))).append((Component)Component.literal((String)" to download!").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW))));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.DUCK.get(), Duck.createAttributes().build());
        event.put((EntityType)ModEntities.CREEPER_NUCLEAR.get(), CreeperNuclear.createAttributes().build());
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            HazardSystem.updatePlayerInventory(player);
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            HazardSystem.updateDroppedItem(itemEntity);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            HazardSystem.updateLivingInventory(livingEntity);
            EntityEffectHandler.tick(livingEntity);
        }
    }

    public static void RerollPal() {
        if (generalOverride > 0 && generalOverride < 19) {
            polaroidID = generalOverride;
        } else {
            while ((polaroidID = new Random().nextInt(18) + 1) == 4 || polaroidID == 9) {
            }
        }
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenus.IRON_CRATE.get(), GUICrateIron::new);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        ModCommands.registerCommandLivingProperties((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    static {
        polaroidID = 1;
        generalOverride = 0;
    }
}

