/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface IPersistentNBT {
    public static final String NBT_PERSISTENT_KEY = "persistent";

    public void writeNBT(CompoundTag var1);

    public void readNBT(CompoundTag var1);

    default public List<ItemStack> getDrops(Block block) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack stack = new ItemStack((ItemLike)block);
        CompoundTag data = new CompoundTag();
        this.writeNBT(data);
        if (!data.isEmpty()) {
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)data));
        }
        list.add(stack);
        return list;
    }

    public static List<ItemStack> getDrops(Level level, BlockPos pos, Block block) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof IPersistentNBT) {
            IPersistentNBT persistent = (IPersistentNBT)be;
            return persistent.getDrops(block);
        }
        return new ArrayList<ItemStack>();
    }

    public static void restoreData(Level level, BlockPos pos, ItemStack stack) {
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            return;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof IPersistentNBT) {
            IPersistentNBT persistent = (IPersistentNBT)be;
            CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
            persistent.readNBT(tag);
        }
    }
}

