/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity;

import api.hbm.tile.ILoadedTile;
import com.hbm.blockentity.IBufPacketReceiver;
import com.hbm.network.toclient.BufNT;
import com.hbm.sound.AudioWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class LoadedBaseBlockEntity
extends BlockEntity
implements ILoadedTile,
IBufPacketReceiver {
    public boolean isLoaded = true;
    public boolean muffled = false;
    private ByteBuf lastPackedBuf;

    public LoadedBaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void onChunkUnloaded() {
        this.isLoaded = false;
    }

    public AudioWrapper createAudioLoop() {
        return null;
    }

    public AudioWrapper rebootAudio(AudioWrapper wrapper) {
        wrapper.stopSound();
        AudioWrapper audio = this.createAudioLoop();
        audio.startSound();
        return audio;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.muffled = tag.getBoolean("muffled");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("muffled", this.muffled);
    }

    public float getVolume(float baseVolume) {
        return this.muffled ? baseVolume * 0.1f : baseVolume;
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeBoolean(this.muffled);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.muffled = buf.readBoolean();
    }

    public void networkPackNT(int range) {
        if (this.level.isClientSide) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.serialize((ByteBuf)buf);
        BufNT packet = new BufNT(this.worldPosition, buf);
        if (buf.equals((Object)this.lastPackedBuf) && this.level.getGameTime() % 20L != 0L) {
            return;
        }
        this.lastPackedBuf = new FriendlyByteBuf(buf.copy());
        PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)this.level), null, (double)((double)this.worldPosition.getX() + 0.5), (double)((double)this.worldPosition.getY() + 0.5), (double)((double)this.worldPosition.getZ() + 0.5), (double)range, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

