/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.bomb;

import com.hbm.blockentity.ModBlockEntities;
import com.hbm.blocks.bomb.CrashedBombBlock;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class CrashedBombBlockEntity
extends BlockEntity {
    protected final EnumDudType dudType;

    public CrashedBombBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, EnumDudType dudType) {
        super(type, pos, state);
        this.dudType = dudType;
    }

    public static CrashedBombBlockEntity balefire(BlockPos pos, BlockState state) {
        return new CrashedBombBlockEntity(ModBlockEntities.CRASHED_BOMB_BALEFIRE.get(), pos, state, EnumDudType.BALEFIRE);
    }

    public static CrashedBombBlockEntity conventional(BlockPos pos, BlockState state) {
        return new CrashedBombBlockEntity(ModBlockEntities.CRASHED_BOMB_CONVENTIONAL.get(), pos, state, EnumDudType.CONVENTIONAL);
    }

    public static CrashedBombBlockEntity nuke(BlockPos pos, BlockState state) {
        return new CrashedBombBlockEntity(ModBlockEntities.CRASHED_BOMB_NUKE.get(), pos, state, EnumDudType.NUKE);
    }

    public static CrashedBombBlockEntity salted(BlockPos pos, BlockState state) {
        return new CrashedBombBlockEntity(ModBlockEntities.CRASHED_BOMB_SALTED.get(), pos, state, EnumDudType.SALTED);
    }

    public EnumDudType getDudType() {
        return this.dudType;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrashedBombBlockEntity be) {
        if (!(state.getBlock() instanceof CrashedBombBlock)) {
            return;
        }
        if (level.getGameTime() % 2L == 0L) {
            EnumDudType type = be.dudType;
            if (type == EnumDudType.BALEFIRE) {
                be.affectEntities(level, pos, (entity, intensity) -> ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 1.0f * intensity.floatValue()), 15.0);
            } else if (type == EnumDudType.NUKE) {
                be.affectEntities(level, pos, (entity, intensity) -> ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 0.25f * intensity.floatValue()), 10.0);
            } else if (type == EnumDudType.SALTED) {
                be.affectEntities(level, pos, (entity, intensity) -> ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 0.5f * intensity.floatValue()), 10.0);
            }
        }
    }

    private void affectEntities(Level level, BlockPos pos, BiConsumer<LivingEntity, Float> effect, double range) {
        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(range));
        for (LivingEntity entity : entities) {
            double dz;
            double dy;
            double dx = entity.getX() - ((double)pos.getX() + 0.5);
            double dist = Math.sqrt(dx * dx + (dy = entity.getY() + (double)(entity.getBbHeight() / 2.0f) - ((double)pos.getY() + 0.5)) * dy + (dz = entity.getZ() - ((double)pos.getZ() + 0.5)) * dz);
            if (dist > range) continue;
            float intensity = (float)(1.0 - dist / range);
            effect.accept(entity, Float.valueOf(intensity));
        }
    }

    public static enum EnumDudType {
        BALEFIRE,
        CONVENTIONAL,
        NUKE,
        SALTED;

    }
}

