/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blockentity.machine.storage;

import com.hbm.blockentity.machine.LockableBaseBlockEntity;
import com.hbm.lib.ModSounds;
import com.hbm.util.TagsUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class CrateBaseBlockEntity
extends LockableBaseBlockEntity
implements WorldlyContainer,
MenuProvider {
    protected NonNullList<ItemStack> items;
    private final int[] allSlots;
    public String customName;
    public boolean hasSpiders = false;
    private static final int NUM_SPIDERS = 3;

    public CrateBaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int size) {
        super(type, pos, state);
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        this.allSlots = new int[size];
        for (int i = 0; i < size; ++i) {
            this.allSlots[i] = i;
        }
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player player) {
        return null;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack result = ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack result = (ItemStack)this.items.get(slot);
        if (result.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(slot, (Object)ItemStack.EMPTY);
        return result;
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void setCustomName(String name) {
        this.customName = name;
        this.setChanged();
    }

    public void startOpen(Player player) {
        if (this.level != null) {
            this.level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.CRATE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void stopOpen(Player player) {
        if (this.level != null) {
            this.level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.CRATE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return true;
    }

    public int getMaxStackSize() {
        return 64;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putBoolean("Spiders", this.hasSpiders);
        if (this.customName != null) {
            tag.putString("CustomName", this.customName);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.hasSpiders = tag.getBoolean("Spiders");
        if (tag.contains("CustomName")) {
            this.customName = tag.getString("CustomName");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public int[] getSlotsForFace(Direction side) {
        return this.allSlots;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return this.canPlaceItem(slot, stack) && !this.isLocked();
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return !this.isLocked();
    }

    public void fillWithSpiders() {
        this.hasSpiders = true;
    }

    public static void spawnSpiders(Player player, Level level, CrateBaseBlockEntity crate) {
        if (crate.hasSpiders) {
            Random random = new Random();
            for (int i = 0; i < 3; ++i) {
                CaveSpider spider = new CaveSpider(EntityType.CAVE_SPIDER, level);
                spider.moveTo((double)crate.getBlockPos().getX() + random.nextGaussian() * 2.0, (double)(crate.getBlockPos().getY() + 1), (double)crate.getBlockPos().getZ() + random.nextGaussian() * 2.0, random.nextFloat(), 0.0f);
                spider.setTarget((LivingEntity)player);
                level.addFreshEntity((Entity)spider);
            }
            crate.hasSpiders = false;
            crate.setChanged();
        }
    }

    public static void spawnSpiders(Player player, Level level, ItemStack stack) {
        if (TagsUtil.getTagElement(stack, "spiders") != null) {
            Random random = new Random();
            for (int i = 0; i < 3; ++i) {
                CaveSpider spider = new CaveSpider(EntityType.CAVE_SPIDER, level);
                spider.moveTo(player.getX() + random.nextGaussian() * 2.0, player.getY() + 1.0, player.getZ() + random.nextGaussian() * 2.0, random.nextFloat(), 0.0f);
                spider.setTarget((LivingEntity)player);
                level.addFreshEntity((Entity)spider);
            }
            TagsUtil.removeTag(stack, "spiders");
        }
    }
}

