/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.lib.ModEffect;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BalefireBlock
extends BaseFireBlock {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)15);
    public static final MapCodec<BalefireBlock> CODEC = BalefireBlock.simpleCodec(BalefireBlock::new);

    public BalefireBlock(BlockBehaviour.Properties properties) {
        super(properties, 1.0f);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseFireBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected boolean canBurn(BlockState state) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            level.scheduleTick(pos, (Block)this, this.getCustomFireTickDelay(level.getRandom()));
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            return;
        }
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.removeBlock(pos, false);
            return;
        }
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 15) {
            level.scheduleTick(pos, (Block)this, this.getCustomFireTickDelay(rand));
        }
        if (!this.canCatchFireAround((LevelReader)level, pos) && !level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        } else if (age < 15) {
            for (Direction dir : Direction.values()) {
                this.tryCatchFire((Level)level, pos.relative(dir), 300, rand, age, dir.getOpposite());
            }
            int h = 3;
            for (int dx = -h; dx <= h; ++dx) {
                for (int dz = -h; dz <= h; ++dz) {
                    for (int dy = -1; dy <= 4; ++dy) {
                        int adjusted;
                        int spread;
                        int neighAge;
                        BlockState bs;
                        BlockPos check = pos.offset(dx, dy, dz);
                        if (check.equals((Object)pos)) continue;
                        int fireLimit = 100;
                        if (dy > 1) {
                            fireLimit += (dy - 1) * 100;
                        }
                        if ((bs = level.getBlockState(check)).is((Block)this) && (neighAge = ((Integer)bs.getValue((Property)AGE)).intValue()) > age + 1) {
                            level.setBlock(check, (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min(15, age + 1))), 3);
                            continue;
                        }
                        if (!level.isEmptyBlock(check) || (spread = this.getNeighborEncouragement((LevelReader)level, check)) <= 0 || (adjusted = (spread + 40 + level.getDifficulty().getId() * 7) / (age + 30)) <= 0 || rand.nextInt(fireLimit) > adjusted) continue;
                        level.setBlock(check, (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min(15, age + 1))), 3);
                    }
                }
            }
        }
    }

    private void tryCatchFire(Level level, BlockPos pos, int chance, RandomSource random, int age, Direction face) {
        int i = level.getBlockState(pos).getFlammability((BlockGetter)level, pos, face);
        if (random.nextInt(chance) < i) {
            BlockState blockstate = level.getBlockState(pos);
            blockstate.onCaughtFire(level, pos, face, null);
            if (random.nextInt(age + 10) < 5 && !level.isRainingAt(pos)) {
                level.setBlock(pos, (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min(15, age + 1))), 3);
            } else {
                level.removeBlock(pos, false);
            }
        }
    }

    private boolean canCatchFireAround(LevelReader level, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            BlockPos np = pos.relative(dir);
            BlockState ns = level.getBlockState(np);
            if (!ns.isFlammable((BlockGetter)level, np, dir.getOpposite())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(LevelReader level, BlockPos pos) {
        if (!level.isEmptyBlock(pos)) {
            return 0;
        }
        int best = 0;
        for (Direction dir : Direction.values()) {
            BlockPos np = pos.relative(dir);
            BlockState ns = level.getBlockState(np);
            int f = ns.getFlammability((BlockGetter)level, np, dir.getOpposite());
            if (f <= best) continue;
            best = f;
        }
        return best;
    }

    private int getCustomFireTickDelay(RandomSource rand) {
        return 30 + rand.nextInt(10);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.setRemainingFireTicks(200);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(ModEffect.RADIATION, 100, 9));
        }
    }
}

