/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blockentity.ModBlockEntities;
import com.hbm.blockentity.bomb.LandMineBlockEntity;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorWater;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCrossSmooth;
import com.hbm.explosion.vanillant.standard.ExplosionEffectWeapon;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.interfaces.IBomb;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LandmineBlock
extends BaseEntityBlock
implements IBomb {
    private static final VoxelShape SHAPE_AP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    private static final VoxelShape SHAPE_HE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape SHAPE_SHRAP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    private static final VoxelShape SHAPE_FAT = Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)6.0, (double)12.0);
    public static boolean safeMode = false;
    public double range;
    public double height;
    public static final MapCodec<LandmineBlock> CODEC = LandmineBlock.simpleCodec(LandmineBlock::new);

    protected LandmineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public LandmineBlock(BlockBehaviour.Properties properties, double range, double height) {
        this(properties);
        this.range = range;
        this.height = height;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new LandMineBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type, ModBlockEntities.LANDMINE.get(), LandMineBlockEntity::serverTick);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        BlockPos below = pos.below();
        if (!level.getBlockState(below).isFaceSturdy((BlockGetter)level, below, Direction.UP)) {
            Block.dropResources((BlockState)level.getBlockState(pos), (Level)level, (BlockPos)pos);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide) {
            BlockPos below;
            if (level.hasNeighborSignal(pos)) {
                this.explode(level, pos.getX(), pos.getY(), pos.getZ());
            }
            if (!level.getBlockState(below = pos.below()).isFaceSturdy((BlockGetter)level, below, Direction.UP)) {
                if (!safeMode) {
                    this.explode(level, pos.getX(), pos.getY(), pos.getZ());
                } else {
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!safeMode) {
            this.explode(level, pos.getX(), pos.getY(), pos.getZ());
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    public IBomb.BombReturnCode explode(Level level, int x, int y, int z) {
        safeMode = true;
        level.setBlock(new BlockPos(x, y, z), Blocks.AIR.defaultBlockState(), 3);
        safeMode = false;
        if (!level.isClientSide) {
            ExplosionVNT vnt = new ExplosionVNT(level, x + 5, y + 5, z + 5, 25.0f);
            vnt.setBlockAllocator(new BlockAllocatorWater(32));
            vnt.setBlockProcessor(new BlockProcessorStandard());
            vnt.setEntityProcessor(new EntityProcessorCrossSmooth(0.5, 75.0f).setupPiercing(5.0f, 0.2f));
            vnt.setPlayerProcessor(new PlayerProcessorStandard());
            vnt.setSFX(new ExplosionEffectWeapon(10, 1.0f, 0.5f));
            vnt.explode();
            ExplosionLarge.spawnParticlesRadial((ServerLevel)level, (double)x + 0.5, y + 2, (double)z + 0.5, 30);
            if (this.isWaterAbove(level, x, y, z)) {
                ExplosionLarge.spawnFoam((ServerLevel)level, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 60);
            }
        }
        return IBomb.BombReturnCode.DETONATED;
    }

    public boolean isWaterAbove(Level level, int x, int y, int z) {
        for (int xo = -1; xo <= 1; ++xo) {
            for (int zo = -1; zo <= 1; ++zo) {
                if (!level.getFluidState(new BlockPos(x + xo, y + 1, z + zo)).is(FluidTags.WATER)) continue;
                return true;
            }
        }
        return false;
    }
}

