/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.gas;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class GasBaseBlock
extends Block {
    public GasBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        return true;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return false;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 10);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean isMoving) {
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 10);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.tryMove(level, pos, this.getFirstDirection((Level)level, pos)) && !this.tryMove(level, pos, this.getSecondDirection((Level)level, pos))) {
            level.scheduleTick(pos, (Block)this, this.getDelay((LevelAccessor)level));
        }
    }

    public abstract Direction getFirstDirection(Level var1, BlockPos var2);

    public Direction getSecondDirection(Level level, BlockPos pos) {
        return this.getFirstDirection(level, pos);
    }

    public boolean tryMove(ServerLevel level, BlockPos pos, Direction dir) {
        BlockPos targetPos = pos.relative(dir);
        if (level.getBlockState(targetPos).isAir()) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            level.setBlock(targetPos, this.defaultBlockState(), 2);
            level.scheduleTick(targetPos, (Block)this, this.getDelay((LevelAccessor)level));
            return true;
        }
        return false;
    }

    public int getDelay(LevelAccessor levelAccessor) {
        return 2;
    }

    public Direction randomHorizontal(RandomSource random) {
        return Direction.Plane.HORIZONTAL.getRandomDirection(random);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
    }
}

