/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ModBlocks;
import com.hbm.extprop.LivingProperties;
import com.hbm.lib.ModEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FalloutBlock
extends Block {
    public FalloutBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return false;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide && entity instanceof LivingEntity) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).isCreative()) {
                return;
            }
            if (livingEntity instanceof Player && (player = (Player)livingEntity).isSpectator()) {
                return;
            }
            livingEntity.addEffect(new MobEffectInstance(ModEffect.RADIATION, 100, 0));
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            LivingProperties.addCont((LivingEntity)player, new LivingProperties.ContaminationEffect(1.0f, 200, false));
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.below());
        return !blockstate.is(BlockTags.SNOW_LAYER_CANNOT_SURVIVE_ON);
    }

    public static boolean canPlaceBlockAt(Level level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState belowState = level.getBlockState(below);
        if (FalloutBlock.isPlant(belowState)) {
            return false;
        }
        if (belowState.is((Block)ModBlocks.FALLOUT.get())) {
            return false;
        }
        if (belowState.isAir()) {
            return false;
        }
        return belowState.isSolidRender((BlockGetter)level, below);
    }

    public static boolean isPlant(BlockState state) {
        return state.is(BlockTags.CROPS) || state.is(BlockTags.FLOWERS) || state.is(BlockTags.LEAVES) || state.is(BlockTags.SAPLINGS);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }
}

