/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class FlammableBlock
extends Block {
    public int encouragement;
    public int flammability;

    public FlammableBlock(BlockBehaviour.Properties properties, int encouragement, int flammability) {
        super(properties);
        this.encouragement = encouragement;
        this.flammability = flammability;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.encouragement;
    }

    public boolean shouldIgnite(Level level, BlockPos pos) {
        if (this.flammability == 0) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = pos.relative(dir);
            if (!level.getBlockState(neighborPos).is(Blocks.FIRE)) continue;
            return true;
        }
        return false;
    }
}

