/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.hazard.HazardRegistry;
import com.hbm.hazard.HazardSystem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class HazardBlock
extends Block {
    protected float rad = 0.0f;

    public HazardBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.rad > 0.0f) {
            ChunkRadiationManager.proxy.incrementRad((Level)level, pos.getX(), pos.getY(), pos.getZ(), this.rad);
            level.scheduleTick(pos, (Block)this, 20);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.rad = HazardSystem.getHazardLevelFromStack(new ItemStack((ItemLike)this), HazardRegistry.RADIATION) * 0.1f;
        if (this.rad > 0.0f && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.scheduleTick(pos, (Block)this, 20);
        }
    }
}

