/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blockentity.machine.storage.CrateBaseBlockEntity;
import com.hbm.blockentity.machine.storage.CrateIronBlockEntity;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.MainConfig;
import com.hbm.util.TagsUtil;
import com.mojang.serialization.MapCodec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class StorageCrateBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private final boolean isSafe;
    public static final MapCodec<StorageCrateBlock> CODEC = StorageCrateBlock.simpleCodec(StorageCrateBlock::new);

    public StorageCrateBlock(BlockBehaviour.Properties properties, boolean isSafe) {
        super(properties);
        this.isSafe = isSafe;
        if (isSafe) {
            this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        }
    }

    public StorageCrateBlock(BlockBehaviour.Properties properties) {
        this(properties, false);
    }

    protected MapCodec<? extends StorageCrateBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (this == ModBlocks.IRON_CRATE.get()) {
            return new CrateIronBlockEntity(pos, state);
        }
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        CrateBaseBlockEntity crate;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CrateBaseBlockEntity && (crate = (CrateBaseBlockEntity)blockEntity).canAccess(player)) {
            player.openMenu((MenuProvider)crate, pos);
            CrateBaseBlockEntity.spawnSpiders(player, level, crate);
        }
        return InteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        CompoundTag tag;
        if (this.isSafe && placer != null) {
            level.setBlock(pos, (BlockState)state.setValue((Property)FACING, (Comparable)placer.getDirection().getOpposite()), 2);
        }
        if (TagsUtil.hasTag(stack) && (tag = TagsUtil.getTag(stack)).contains("BlockEntityTag")) {
            CompoundTag blockEntityTag = tag.getCompound("BlockEntityTag");
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                blockEntity.loadCustomOnly(blockEntityTag, (HolderLookup.Provider)level.registryAccess());
                if (blockEntity instanceof CrateBaseBlockEntity) {
                    CrateBaseBlockEntity crate = (CrateBaseBlockEntity)blockEntity;
                    crate.setCustomName(String.valueOf(stack.getDisplayName()));
                }
            }
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrateBaseBlockEntity) {
            CrateBaseBlockEntity lockable = (CrateBaseBlockEntity)blockEntity;
            if (!level.isClientSide && !player.isCreative()) {
                boolean keepContents = (Boolean)MainConfig.SERVER.CRATE_KEEP_CONTENTS.get();
                boolean isLocked = lockable.isLocked();
                if (!keepContents && !isLocked) {
                    return super.playerWillDestroy(level, pos, state, player);
                }
                ItemStack drop = new ItemStack((ItemLike)this);
                CompoundTag blockEntityTag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
                blockEntityTag.remove("x");
                blockEntityTag.remove("y");
                blockEntityTag.remove("z");
                if (!blockEntityTag.isEmpty()) {
                    try {
                        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                        try (GZIPOutputStream gzipoutputstream = new GZIPOutputStream(bytearrayoutputstream);){
                            DataOutputStream dataOutputStream = new DataOutputStream(gzipoutputstream);
                            NbtIo.write((CompoundTag)blockEntityTag, (DataOutput)dataOutputStream);
                        }
                        if (bytearrayoutputstream.size() > 6000) {
                            player.sendSystemMessage((Component)Component.literal((String)"Warning: Container NBT exceeds 6kB, contents will be ejected!").withStyle(ChatFormatting.RED));
                        } else {
                            drop.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                StorageCrateBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CrateBaseBlockEntity) {
                CrateBaseBlockEntity crate = (CrateBaseBlockEntity)blockEntity;
                boolean keepContents = (Boolean)MainConfig.SERVER.CRATE_KEEP_CONTENTS.get();
                boolean isLocked = crate.isLocked();
                if (!keepContents || isLocked) {
                    Containers.dropContents((Level)level, (BlockPos)pos, (Container)crate);
                    level.updateNeighbourForOutputSignal(pos, (Block)this);
                }
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        CompoundTag blockEntityTag = TagsUtil.getTagElement(stack, "BlockEntityTag");
        if (blockEntityTag != null) {
            ListTag items;
            if (blockEntityTag.getBoolean("spiders")) {
                if (blockEntityTag.contains("lock")) {
                    tooltip.add((Component)Component.literal((String)"This container is locked.").withStyle(ChatFormatting.RED));
                }
                tooltip.add((Component)Component.literal((String)"Skittering emanates from within...").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                return;
            }
            if (blockEntityTag.contains("lock")) {
                tooltip.add((Component)Component.literal((String)"This container is locked.").withStyle(ChatFormatting.RED));
                if (blockEntityTag.contains("Items") && !blockEntityTag.getList("Items", 10).isEmpty()) {
                    tooltip.add((Component)Component.literal((String)"It feels heavy...").withStyle(ChatFormatting.YELLOW));
                } else {
                    tooltip.add((Component)Component.literal((String)"It feels empty...").withStyle(ChatFormatting.YELLOW));
                }
                return;
            }
            if (blockEntityTag.contains("Items") && !(items = blockEntityTag.getList("Items", 10)).isEmpty()) {
                tooltip.add((Component)Component.literal((String)"Contains:").withStyle(ChatFormatting.AQUA));
                int limit = Math.min(items.size(), 10);
                for (int i = 0; i < limit; ++i) {
                    CompoundTag itemTag = items.getCompound(i);
                    ItemStack contentStack = ItemStack.parse((HolderLookup.Provider)Objects.requireNonNull(context.registries()), (Tag)itemTag).orElse(ItemStack.EMPTY);
                    tooltip.add((Component)Component.literal((String)" - ").append(contentStack.getHoverName()).append(" x" + contentStack.getCount()).withStyle(ChatFormatting.AQUA));
                }
                if (items.size() > limit) {
                    tooltip.add((Component)Component.literal((String)("...and " + (items.size() - limit) + " more.")).withStyle(ChatFormatting.AQUA));
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.isSafe) {
            builder.add(new Property[]{FACING});
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (this.isSafe) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        }
        return super.getStateForPlacement(context);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrateBaseBlockEntity) {
            CrateBaseBlockEntity crate = (CrateBaseBlockEntity)blockEntity;
            return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)crate);
        }
        return 0;
    }
}

