/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.entity.ModEntities;
import com.hbm.render.entity.effect.RenderTorex;
import com.hbm.util.BobMathUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NukeTorex
extends Entity {
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(NukeTorex.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(NukeTorex.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public double coreHeight = 3.0;
    public double convectionHeight = 3.0;
    public double torusWidth = 3.0;
    public double rollerSize = 1.0;
    public double heat = 1.0;
    public double lastSpawnY = -1.0;
    public final List<Cloudlet> cloudlets = new ArrayList<Cloudlet>();
    public boolean didPlaySound = false;
    public boolean didShake = false;

    public NukeTorex(EntityType<? extends NukeTorex> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.setInvulnerable(true);
        this.noCulling = true;
        this.setBoundingBox(new AABB(this.getX() - 0.5, this.getY(), this.getZ() - 0.5, this.getX() + 0.5, this.getY() + 50.0, this.getZ() + 0.5));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SCALE, (Object)Float.valueOf(1.0f));
        builder.define(TYPE, (Object)0);
    }

    public void tick() {
        super.tick();
        double s = 1.5;
        double cs = 1.5;
        int maxAge = this.getMaxAge();
        if (this.level().isClientSide) {
            Cloudlet cloud;
            int i;
            if (this.tickCount == 1) {
                this.setScale((float)s);
            }
            if (this.lastSpawnY == -1.0) {
                this.lastSpawnY = this.getY() - 3.0;
            }
            if (this.tickCount < 100) {
                this.level().setSkyFlashTime(3);
            }
            int spawnTarget = this.level().getHeight(Heightmap.Types.WORLD_SURFACE, (int)this.getX(), (int)this.getZ()) - 3;
            double moveSpeed = 0.5;
            this.lastSpawnY = Math.abs((double)spawnTarget - this.lastSpawnY) < moveSpeed ? (double)spawnTarget : (this.lastSpawnY += moveSpeed * Math.signum((double)spawnTarget - this.lastSpawnY));
            double range = (this.torusWidth - this.rollerSize) * 0.25;
            double simSpeed = this.getSimulationSpeed();
            int toSpawn = (int)Math.ceil(10.0 * simSpeed * simSpeed);
            int lifetime = Math.min(this.tickCount * this.tickCount + 200, maxAge - this.tickCount + 200);
            for (i = 0; i < toSpawn; ++i) {
                double x2 = this.getX() + this.random.nextGaussian() * range;
                double z = this.getZ() + this.random.nextGaussian() * range;
                Cloudlet cloud2 = new Cloudlet(x2, this.lastSpawnY, z, (float)(this.random.nextDouble() * 2.0 * Math.PI), 0, lifetime);
                cloud2.setScale(1.0f + (float)this.tickCount * 0.005f * (float)cs, 5.0f * (float)cs);
                this.cloudlets.add(cloud2);
            }
            if (this.tickCount < 150) {
                int cloudCount = this.tickCount * 5;
                int shockLife = Math.max(300 - this.tickCount * 20, 50);
                for (int i2 = 0; i2 < cloudCount; ++i2) {
                    float rot = (float)(Math.PI * 2 * this.random.nextDouble());
                    Vec3 vec = new Vec3(((double)this.tickCount * 1.5 + this.random.nextDouble()) * 1.5, 0.0, 0.0).yRot(rot);
                    this.cloudlets.add(new Cloudlet(vec.x + this.getX(), this.level().getHeight(Heightmap.Types.WORLD_SURFACE, (int)(vec.x + this.getX()), (int)(vec.z + this.getZ())), vec.z + this.getZ(), rot, 0, shockLife, TorexType.SHOCK).setScale(7.0f, 2.0f).setMotion(this.tickCount > 15 ? 0.75 : 0.0));
                }
                if (!this.didPlaySound) {
                    RenderTorex.handleExplosionEffect(this, this.tickCount);
                }
            }
            if ((double)this.tickCount < 130.0 * s) {
                lifetime = (int)((double)lifetime * s);
                for (i = 0; i < 2; ++i) {
                    Cloudlet cloud3 = new Cloudlet(this.getX(), this.getY() + this.coreHeight, this.getZ(), (float)(this.random.nextDouble() * 2.0 * Math.PI), 0, lifetime, TorexType.RING);
                    cloud3.setScale(1.0f + (float)this.tickCount * 0.0025f * (float)(cs * cs), 3.0f * (float)(cs * cs));
                    this.cloudlets.add(cloud3);
                }
            }
            if ((double)this.tickCount > 130.0 * s && (double)this.tickCount < 600.0 * s) {
                for (i = 0; i < 20; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        float angle = (float)(Math.PI * 2 * this.random.nextDouble());
                        Vec3 vec = new Vec3(this.torusWidth + this.rollerSize * (5.0 + this.random.nextDouble()), 0.0, 0.0).zRot((float)(0.06981317007977318 * (double)j)).yRot(angle);
                        cloud = new Cloudlet(this.getX() + vec.x, this.getY() + this.coreHeight - 5.0 + (double)j * s, this.getZ() + vec.z, angle, 0, (int)((double)(20 + this.tickCount / 10) * (1.0 + this.random.nextDouble() * 0.1)), TorexType.CONDENSATION);
                        cloud.setScale(0.125f * (float)cs, 3.0f * (float)cs);
                        this.cloudlets.add(cloud);
                    }
                }
            }
            if ((double)this.tickCount > 200.0 * s && (double)this.tickCount < 600.0 * s) {
                for (i = 0; i < 20; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        float angle = (float)(Math.PI * 2 * this.random.nextDouble());
                        Vec3 vec = new Vec3(this.torusWidth + this.rollerSize * (3.0 + this.random.nextDouble() * 0.5), 0.0, 0.0).zRot((float)(0.06981317007977318 * (double)j)).yRot(angle);
                        cloud = new Cloudlet(this.getX() + vec.x, this.getY() + this.coreHeight + 25.0 + (double)j * cs, this.getZ() + vec.z, angle, 0, (int)((double)(20 + this.tickCount / 10) * (1.0 + this.random.nextDouble() * 0.1)), TorexType.CONDENSATION);
                        cloud.setScale(0.125f * (float)cs, 3.0f * (float)cs);
                        this.cloudlets.add(cloud);
                    }
                }
            }
            for (Cloudlet cloud4 : this.cloudlets) {
                cloud4.update();
            }
            this.coreHeight += 0.15 / s;
            this.torusWidth += 0.05 / s;
            this.rollerSize = this.torusWidth * 0.35;
            this.convectionHeight = this.coreHeight + this.rollerSize;
            int maxHeat = (int)(50.0 * cs);
            this.heat = (double)maxHeat - Math.pow((double)(maxHeat * this.tickCount) / (double)maxAge, 1.0);
            this.cloudlets.removeIf(x -> x.isDead);
        }
        if (!this.level().isClientSide && this.tickCount > maxAge) {
            this.discard();
        }
    }

    public NukeTorex setScale(float scale) {
        if (!this.level().isClientSide) {
            this.entityData.set(SCALE, (Object)Float.valueOf(scale));
        }
        this.coreHeight = this.coreHeight / 1.5 * (double)scale;
        this.convectionHeight = this.convectionHeight / 1.5 * (double)scale;
        this.torusWidth = this.torusWidth / 1.5 * (double)scale;
        this.rollerSize = this.rollerSize / 1.5 * (double)scale;
        return this;
    }

    public NukeTorex setType(int type) {
        this.entityData.set(TYPE, (Object)type);
        return this;
    }

    public double getSimulationSpeed() {
        int lifetime = this.getMaxAge();
        int simSlow = lifetime / 4;
        int life = this.tickCount;
        int simStop = lifetime / 2;
        if (life > simStop) {
            return 0.0;
        }
        if (life > simSlow) {
            return 1.0 - (double)(life - simSlow) / (double)(simStop - simSlow);
        }
        return 1.0;
    }

    public double getScale() {
        return ((Float)this.entityData.get(SCALE)).floatValue();
    }

    public double getGreying() {
        int lifetime = this.getMaxAge();
        int greying = lifetime * 3 / 4;
        if (this.tickCount > greying) {
            return 1.0 + (double)(this.tickCount - greying) / (double)(lifetime - greying);
        }
        return 1.0;
    }

    public float getAlpha() {
        int life = this.tickCount;
        int lifetime = this.getMaxAge();
        int fadeOut = lifetime * 3 / 4;
        if (life > fadeOut) {
            float fac = (float)(life - fadeOut) / (float)(lifetime - fadeOut);
            return 1.0f - fac;
        }
        return 1.0f;
    }

    public int getMaxAge() {
        double s = this.getScale();
        return (int)(900.0 * s);
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public static void statFacStandard(Level level, double x, double y, double z, float scale) {
        NukeTorex.statFac(level, x, y, z, scale, 0);
    }

    public static void statFacBale(Level level, double x, double y, double z, float scale) {
        NukeTorex.statFac(level, x, y, z, scale, 1);
    }

    public static void statFac(Level level, double x, double y, double z, float scale, int type) {
        NukeTorex torex = new NukeTorex((EntityType<? extends NukeTorex>)((EntityType)ModEntities.NUKE_TOREX.get()), level).setScale(Mth.clamp((float)((float)BobMathUtil.squirt((double)scale * 0.01) * 1.5f), (float)0.5f, (float)5.0f));
        torex.setType(type);
        torex.moveTo(x, y, z);
        level.addFreshEntity((Entity)torex);
    }

    public class Cloudlet {
        public double posX;
        public double posY;
        public double posZ;
        public double prevPosX;
        public double prevPosY;
        public double prevPosZ;
        public double motionX;
        public double motionY;
        public double motionZ;
        public int age;
        public int cloudletLife;
        public float angle;
        public boolean isDead = false;
        float rangeMod;
        public float colorMod;
        public Vec3 color;
        public Vec3 prevColor;
        public TorexType type;
        private float startingScale = 1.0f;
        private float growingScale = 5.0f;
        private double motionMult = 1.0;

        public Cloudlet(double posX, double posY, double posZ, float angle, int age, int maxAge) {
            this(posX, posY, posZ, angle, age, maxAge, TorexType.STANDARD);
        }

        public Cloudlet(double posX, double posY, double posZ, float angle, int age, int maxAge, TorexType type) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.age = age;
            this.cloudletLife = maxAge;
            this.angle = angle;
            this.rangeMod = 0.3f + NukeTorex.this.random.nextFloat() * 0.7f;
            this.colorMod = 0.8f + NukeTorex.this.random.nextFloat() * 0.2f;
            this.type = type;
            this.updateColor();
        }

        private void update() {
            ++this.age;
            if (this.age > this.cloudletLife) {
                this.isDead = true;
            }
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            Vec3 simPos = new Vec3(NukeTorex.this.getX() - this.posX, 0.0, NukeTorex.this.getZ() - this.posZ);
            double simPosX = NukeTorex.this.getX() + simPos.length();
            double simPosZ = NukeTorex.this.getZ();
            if (this.type == TorexType.STANDARD) {
                Vec3 convection = this.getConvectionMotion(simPosX, simPosZ);
                Vec3 lift = this.getLiftMotion(simPosX);
                double factor = Mth.clamp((double)((this.posY - NukeTorex.this.getY()) / NukeTorex.this.coreHeight), (double)0.0, (double)1.0);
                this.motionX = convection.x * factor + lift.x * (1.0 - factor);
                this.motionY = convection.y * factor + lift.y * (1.0 - factor);
                this.motionZ = convection.z * factor + lift.z * (1.0 - factor);
            } else if (this.type == TorexType.SHOCK) {
                double factor = Mth.clamp((double)((this.posY - NukeTorex.this.getY()) / NukeTorex.this.coreHeight), (double)0.0, (double)1.0);
                Vec3 motion = new Vec3(1.0, 0.0, 0.0).yRot(this.angle);
                this.motionX = motion.x * factor;
                this.motionY = motion.y * factor;
                this.motionZ = motion.z * factor;
            } else if (this.type == TorexType.RING) {
                motion = this.getRingMotion(simPosX, simPosZ);
                this.motionX = motion.x;
                this.motionY = motion.y;
                this.motionZ = motion.z;
            } else if (this.type == TorexType.CONDENSATION) {
                motion = this.getCondensationMotion();
                this.motionX = motion.x;
                this.motionY = motion.y;
                this.motionZ = motion.z;
            }
            double mult = this.motionMult * NukeTorex.this.getSimulationSpeed();
            this.posX += this.motionX * mult;
            this.posY += this.motionY * mult;
            this.posZ += this.motionZ * mult;
            this.updateColor();
        }

        private Vec3 getCondensationMotion() {
            Vec3 delta = new Vec3(this.posX - NukeTorex.this.getX(), 0.0, this.posZ - NukeTorex.this.getZ());
            double speed = 2.0E-5 * (double)NukeTorex.this.tickCount;
            return new Vec3(delta.x * speed, 0.0, delta.z * speed);
        }

        private Vec3 getRingMotion(double simPosX, double simPosZ) {
            if (simPosX > NukeTorex.this.getX() + NukeTorex.this.torusWidth * 2.0) {
                return new Vec3(0.0, 0.0, 0.0);
            }
            Vec3 torusPos = new Vec3(NukeTorex.this.getX() + NukeTorex.this.torusWidth, NukeTorex.this.getY() + NukeTorex.this.coreHeight * 0.5, NukeTorex.this.getZ());
            Vec3 delta = new Vec3(torusPos.x - simPosX, torusPos.y - this.posY, torusPos.z - simPosZ);
            double roller = NukeTorex.this.rollerSize * (double)this.rangeMod * 0.25;
            double dist = delta.length() / roller - 1.0;
            double func = 1.0 - Math.pow(Math.E, -dist);
            float angle = (float)(func * Math.PI * 0.5);
            Vec3 rot = new Vec3(-delta.x / dist, -delta.y / dist, -delta.z / dist).zRot(angle);
            Vec3 motion = new Vec3(torusPos.x + rot.x - simPosX, torusPos.y + rot.y - this.posY, torusPos.z + rot.z - simPosZ);
            double speed = 0.001;
            motion = new Vec3(motion.x * speed, motion.y * speed, motion.z * speed).yRot(this.angle);
            motion = motion.normalize();
            return motion;
        }

        private Vec3 getConvectionMotion(double simPosX, double simPosZ) {
            Vec3 torusPos = new Vec3(NukeTorex.this.getX() + NukeTorex.this.torusWidth, NukeTorex.this.getY() + NukeTorex.this.coreHeight, NukeTorex.this.getZ());
            Vec3 delta = new Vec3(torusPos.x - simPosX, torusPos.y - this.posY, torusPos.z - simPosZ);
            double roller = NukeTorex.this.rollerSize * (double)this.rangeMod;
            double dist = delta.length() / roller - 1.0;
            double func = 1.0 - Math.pow(Math.E, -dist);
            float angle = (float)(func * Math.PI * 0.5);
            Vec3 rot = new Vec3(-delta.x / dist, -delta.y / dist, -delta.z / dist).zRot(angle);
            Vec3 motion = new Vec3(torusPos.x + rot.x - simPosX, torusPos.y + rot.y - this.posY, torusPos.z + rot.z - simPosZ).yRot(this.angle);
            motion = motion.normalize();
            return motion;
        }

        private Vec3 getLiftMotion(double simPosX) {
            double scale = Mth.clamp((double)(1.0 - (simPosX - (NukeTorex.this.getX() + NukeTorex.this.torusWidth))), (double)0.0, (double)1.0);
            Vec3 motion = new Vec3(NukeTorex.this.getX() - this.posX, NukeTorex.this.getY() + NukeTorex.this.convectionHeight - this.posY, NukeTorex.this.getZ() - this.posZ);
            motion = motion.normalize();
            motion = new Vec3(motion.x * scale, motion.y * scale, motion.z * scale);
            return motion;
        }

        private void updateColor() {
            this.prevColor = this.color;
            double exX = NukeTorex.this.getX();
            double exY = NukeTorex.this.getY() + NukeTorex.this.coreHeight;
            double exZ = NukeTorex.this.getZ();
            double distX = exX - this.posX;
            double distY = exY - this.posY;
            double distZ = exZ - this.posZ;
            double distSq = distX * distX + distY * distY + distZ * distZ;
            double dist = Math.sqrt(distSq /= NukeTorex.this.heat);
            dist = Math.max(dist, 1.0);
            double col = 2.0 / dist;
            int type = (Integer)NukeTorex.this.entityData.get(TYPE);
            if (type == 1) {
                this.color = new Vec3(Math.max(col * 1.0, 0.25), Math.max(col * 2.0, 0.25), Math.max(col * 0.5, 0.25));
            } else if (type == 2) {
                Color color = Color.getHSBColor(this.angle / 2.0f / (float)Math.PI, 1.0f, 1.0f);
                this.color = this.type == TorexType.RING ? new Vec3(Math.max(col * 1.0, 0.25), Math.max(col * 1.0, 0.25), Math.max(col * 1.0, 0.25)) : new Vec3((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
            } else {
                this.color = new Vec3(Math.max(col * 2.0, 0.25), Math.max(col * 1.5, 0.25), Math.max(col * 0.5, 0.25));
            }
        }

        public Vec3 getInterpPos(float interp) {
            float scale = (float)NukeTorex.this.getScale();
            Vec3 base = new Vec3(this.prevPosX + (this.posX - this.prevPosX) * (double)interp, this.prevPosY + (this.posY - this.prevPosY) * (double)interp, this.prevPosZ + (this.posZ - this.prevPosZ) * (double)interp);
            if (this.type != TorexType.SHOCK) {
                double x = (base.x - NukeTorex.this.getX()) * (double)scale + NukeTorex.this.getX();
                double y = (base.y - NukeTorex.this.getY()) * (double)scale + NukeTorex.this.getY();
                double z = (base.z - NukeTorex.this.getZ()) * (double)scale + NukeTorex.this.getZ();
                base = new Vec3(x, y, z);
            }
            return base;
        }

        public Vec3 getInterpColor(float interp) {
            if (this.type == TorexType.CONDENSATION) {
                return new Vec3(1.0, 1.0, 1.0);
            }
            double greying = NukeTorex.this.getGreying();
            if (this.type == TorexType.RING) {
                greying += 1.0;
            }
            return new Vec3((this.prevColor.x + (this.color.x - this.prevColor.x) * (double)interp) * greying, (this.prevColor.y + (this.color.y - this.prevColor.y) * (double)interp) * greying, (this.prevColor.z + (this.color.z - this.prevColor.z) * (double)interp) * greying);
        }

        public float getAlpha() {
            float alpha = (1.0f - (float)this.age / (float)this.cloudletLife) * NukeTorex.this.getAlpha();
            if (this.type == TorexType.CONDENSATION) {
                alpha = (float)((double)alpha * 0.25);
            }
            return alpha;
        }

        public float getScale() {
            float base = this.startingScale + (float)this.age / (float)this.cloudletLife * this.growingScale;
            if (this.type != TorexType.SHOCK) {
                base *= (float)NukeTorex.this.getScale();
            }
            return base;
        }

        public Cloudlet setScale(float start, float grow) {
            this.startingScale = start;
            this.growingScale = grow;
            return this;
        }

        public Cloudlet setMotion(double mult) {
            this.motionMult = mult;
            return this;
        }
    }

    public static enum TorexType {
        STANDARD,
        SHOCK,
        RING,
        CONDENSATION;

    }
}

