/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import java.util.Comparator;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public abstract class ChunkloadingEntity
extends Entity {
    private static final TicketType<UUID> CHUNK_TICKET = TicketType.create((String)"chunkloading_entity", Comparator.comparing(UUID::toString));
    private ChunkPos loadedChunk;

    protected ChunkloadingEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void onAddedToLevel() {
        Level level;
        super.onAddedToLevel();
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.loadedChunk = new ChunkPos(this.blockPosition());
            server.getChunkSource().addRegionTicket(CHUNK_TICKET, this.loadedChunk, 2, (Object)this.getUUID());
        }
    }

    public void onRemovedFromLevel() {
        Level level;
        super.onRemovedFromLevel();
        if (!this.level().isClientSide && this.loadedChunk != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.getChunkSource().removeRegionTicket(CHUNK_TICKET, this.loadedChunk, 2, (Object)this.getUUID());
            this.loadedChunk = null;
        }
    }

    protected void updateChunkTicket() {
        Level level;
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ChunkPos newPos = new ChunkPos(this.blockPosition());
            if (!newPos.equals((Object)this.loadedChunk)) {
                if (this.loadedChunk != null) {
                    server.getChunkSource().removeRegionTicket(CHUNK_TICKET, this.loadedChunk, 2, (Object)this.getUUID());
                }
                this.loadedChunk = newPos;
                server.getChunkSource().addRegionTicket(CHUNK_TICKET, this.loadedChunk, 2, (Object)this.getUUID());
            }
        }
    }
}

