/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import com.hbm.entity.logic.NukeExplosionMK5;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.lib.ModSounds;
import com.hbm.network.toclient.AuxParticle;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;

public class CreeperNuclear
extends Creeper {
    public CreeperNuclear(EntityType<? extends Creeper> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, source, recentlyHit);
        this.spawnAtLocation((ItemLike)Items.TNT);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            AABB box = this.getBoundingBox().inflate(5.0);
            List list = this.level().getEntitiesOfClass(LivingEntity.class, box);
            for (LivingEntity e : list) {
                ContaminationUtil.contaminate(e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 0.25f);
            }
            if (this.isAlive() && this.getHealth() < this.getMaxHealth() && this.tickCount % 10 == 0) {
                this.heal(1.0f);
            }
        }
    }

    public void ignite() {
        super.ignite();
        this.nuclearExplode();
    }

    private void nuclearExplode() {
        if (!this.level().isClientSide) {
            this.discard();
            boolean mobGriefing = this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
            if (this.isPowered()) {
                CompoundTag data = new CompoundTag();
                data.putString("type", "muke");
                PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)this.level()), null, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)1000.0, (CustomPacketPayload)new AuxParticle(data, this.getX(), this.getY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.MUKE_EXPLOSION.get(), SoundSource.HOSTILE, 15.0f, 1.0f);
                if (mobGriefing) {
                    this.level().addFreshEntity((Entity)NukeExplosionMK5.statFac(this.level(), 50, this.getX(), this.getY(), this.getZ()));
                } else {
                    ExplosionNukeGeneric.dealDamage(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), 100.0);
                }
            }
        }
    }
}

