/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.lib.ModDamageSource;
import com.hbm.network.toclient.ParticleBurstPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityRubble
extends ThrowableProjectile {
    private static final EntityDataAccessor<String> BLOCK_ID = SynchedEntityData.defineId(EntityRubble.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public EntityRubble(EntityType<? extends EntityRubble> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BLOCK_ID, (Object)"minecraft:stone");
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (result instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)result;
            DamageSource src = new DamageSource((Holder)ehr.getEntity().level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ModDamageSource.RUBBLE));
            ehr.getEntity().hurt(src, 15.0f);
        }
        if (this.tickCount > 2) {
            this.discard();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.5f, 1.0f);
            BlockPos pos = new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ());
            if (!this.level().isClientSide && this.level() instanceof ServerLevel) {
                ResourceLocation blockId = ResourceLocation.withDefaultNamespace((String)((String)this.entityData.get(BLOCK_ID)));
                new ParticleBurstPacket(pos, blockId);
            }
        }
    }

    public void setMetaBasedOnBlock(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        this.entityData.set(BLOCK_ID, (Object)id.toString());
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putString("block", (String)this.entityData.get(BLOCK_ID));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.entityData.set(BLOCK_ID, (Object)tag.getString("block"));
    }
}

