/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;

public class ExplosionBalefire {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public int radius2;
    public Level level;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;

    public void saveToNbt(CompoundTag tag, String name) {
        tag.putInt(name + "posX", this.posX);
        tag.putInt(name + "posY", this.posY);
        tag.putInt(name + "posZ", this.posZ);
        tag.putInt(name + "lastposX", this.lastposX);
        tag.putInt(name + "lastposZ", this.lastposZ);
        tag.putInt(name + "radius", this.radius);
        tag.putInt(name + "radius2", this.radius2);
        tag.putInt(name + "n", this.n);
        tag.putInt(name + "nlimit", this.nlimit);
        tag.putInt(name + "shell", this.shell);
        tag.putInt(name + "leg", this.leg);
        tag.putInt(name + "element", this.element);
    }

    public void readFromNbt(CompoundTag tag, String name) {
        this.posX = tag.getInt(name + "posX");
        this.posY = tag.getInt(name + "posY");
        this.posZ = tag.getInt(name + "posZ");
        this.lastposX = tag.getInt(name + "lastposX");
        this.lastposZ = tag.getInt(name + "lastposZ");
        this.radius = tag.getInt(name + "radius");
        this.radius2 = tag.getInt(name + "radius2");
        this.n = Math.max(tag.getInt(name + "n"), 1);
        this.nlimit = tag.getInt(name + "nlimit");
        this.shell = tag.getInt(name + "shell");
        this.leg = tag.getInt(name + "leg");
        this.element = tag.getInt(name + "element");
    }

    public ExplosionBalefire(int x, int y, int z, Level level, int rad) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.level = level;
        this.radius = rad;
        this.radius2 = this.radius * this.radius;
        this.nlimit = this.radius2 * 4;
    }

    public boolean update() {
        if (this.n == 0) {
            return true;
        }
        this.breakColumn(this.lastposX, this.lastposZ);
        this.shell = (int)Math.floor((Math.sqrt(this.n) + 1.0) / 2.0);
        int shell2 = this.shell * 2;
        if (shell2 == 0) {
            return true;
        }
        this.leg = (int)Math.floor((this.n - (shell2 - 1) * (shell2 - 1)) / shell2);
        this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
        int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
        this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
        ++this.n;
        return this.n > this.nlimit;
    }

    private void breakColumn(int x, int z) {
        int dist = (int)((double)this.radius - Math.sqrt(x * x + z * z));
        if (dist > 0) {
            int y;
            int pX = this.posX + x;
            int pZ = this.posZ + z;
            int maxdepth = (int)(10.0 + (double)this.radius * 0.25);
            int depth = (int)((double)(maxdepth * dist / this.radius) + Math.sin((double)dist * 0.15 + 2.0) * 2.0);
            depth = Math.max(y - depth, -64);
            for (y = this.level.getHeight(Heightmap.Types.WORLD_SURFACE, pX, pZ); y > depth; --y) {
                BlockPos pos = new BlockPos(pX, y, pZ);
                this.level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
            if (this.level.random.nextInt(10) == 0) {
                this.level.setBlock(new BlockPos(pX, depth + 1, pZ), ((Block)ModBlocks.BALEFIRE.get()).defaultBlockState(), 3);
            }
            for (int i = depth; i > depth - 5; --i) {
                if (!this.level.getBlockState(new BlockPos(pX, i, pZ)).is(Blocks.STONE)) continue;
                this.level.setBlock(new BlockPos(pX, i, pZ), ((Block)ModBlocks.SELLAFIELD_SLAKED.get()).defaultBlockState(), 3);
            }
        }
    }
}

