/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.entity.ModEntities;
import com.hbm.entity.projectile.EntityRubble;
import com.hbm.entity.projectile.EntityShrapnel;
import com.hbm.network.toclient.AuxParticle;
import com.hbm.particle.ModParticles;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class ExplosionLarge {
    private static final Random rand = new Random();

    @Deprecated
    public static void spawnParticles(ServerLevel level, double x, double y, double z, int count) {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", "smoke");
        tag.putString("mode", "cloud");
        tag.putInt("count", count);
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)x, (double)y, (double)z, (double)250.0, (CustomPacketPayload)new AuxParticle(tag, x, y, z), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void spawnParticlesRadial(ServerLevel level, double x, double y, double z, int count) {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", "smoke");
        tag.putString("mode", "radial");
        tag.putInt("count", count);
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)x, (double)y, (double)z, (double)250.0, (CustomPacketPayload)new AuxParticle(tag, x, y, z), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void spawnFoam(ServerLevel level, double x, double y, double z, int count) {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", "smoke");
        tag.putString("mode", "foamSplash");
        tag.putInt("count", count);
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)x, (double)y, (double)z, (double)250.0, (CustomPacketPayload)new AuxParticle(tag, x, y, z), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void spawnShock(ServerLevel level, double x, double y, double z, int count, double strength) {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", "smoke");
        tag.putString("mode", "shock");
        tag.putInt("count", count);
        tag.putDouble("strength", strength);
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)x, (double)y, (double)z, (double)250.0, (CustomPacketPayload)new AuxParticle(tag, x, y, z), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void spawnBurst(Level level, double x, double y, double z, int count, double strength) {
        Vec3 vec = new Vec3(strength, 0.0, 0.0).yRot((float)Math.toRadians(rand.nextInt(360)));
        for (int i = 0; i < count; ++i) {
            level.addParticle((ParticleOptions)ModParticles.GAS_FLAME.get(), x, y, z, vec.x, 0.0, vec.z);
            vec = vec.yRot((float)Math.toRadians(360.0 / (double)count));
        }
    }

    public static void spawnRubble(Level level, double x, double y, double z, int count) {
        if (level.isClientSide) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            EntityRubble rubble = (EntityRubble)((EntityType)ModEntities.RUBBLE.get()).create(level);
            rubble.setPos(x, y, z);
            rubble.setDeltaMovement(rand.nextGaussian() * 0.75 * (1.0 + (double)count / 50.0), 0.75 * (1.0 + (double)(count + rand.nextInt(count * 5)) / 25.0), rand.nextGaussian() * 0.75 * (1.0 + (double)count / 50.0));
            rubble.setMetaBasedOnBlock(Blocks.STONE);
            level.addFreshEntity((Entity)rubble);
        }
    }

    public static void spawnShrapnels(Level level, double x, double y, double z, int count) {
        if (level.isClientSide) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            EntityShrapnel shrapnel = (EntityShrapnel)((EntityType)ModEntities.SHRAPNEL.get()).create(level);
            shrapnel.setPos(x, y, z);
            shrapnel.setDeltaMovement(rand.nextGaussian() * (1.0 + (double)count / 50.0), ((double)rand.nextFloat() * 0.5 + 0.5) * (1.0 + (double)count / (double)(15 + rand.nextInt(21))) + (double)(rand.nextFloat() / 50.0f * (float)count), rand.nextGaussian() * (1.0 + (double)count / 50.0));
            shrapnel.setTrail(rand.nextInt(3) == 0);
            level.addFreshEntity((Entity)shrapnel);
        }
    }

    public static void spawnTracers(Level level, double x, double y, double z, int count) {
        if (level.isClientSide) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            EntityShrapnel shrapnel = (EntityShrapnel)((EntityType)ModEntities.SHRAPNEL.get()).create(level);
            shrapnel.setPos(x, y, z);
            shrapnel.setDeltaMovement(rand.nextGaussian() * (1.0 + (double)count / 50.0) * 0.25, ((double)rand.nextFloat() * 0.5 + 0.5) * (1.0 + (double)count / (double)(15 + rand.nextInt(21))) + (double)(rand.nextFloat() / 50.0f * (float)count) * 0.25, rand.nextGaussian() * (1.0 + (double)count / 50.0) * 0.25);
            shrapnel.setTrail(true);
            level.addFreshEntity((Entity)shrapnel);
        }
    }

    public static void spawnShrapnelShower(Level level, double x, double y, double z, double motionX, double motionY, double motionZ, int count, double deviation) {
        if (level.isClientSide) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            EntityShrapnel shrapnel = (EntityShrapnel)((EntityType)ModEntities.SHRAPNEL.get()).create(level);
            shrapnel.setPos(x, y, z);
            shrapnel.setDeltaMovement(motionX + rand.nextGaussian() * deviation, motionY + rand.nextGaussian() * deviation, motionZ + rand.nextGaussian() * deviation);
            shrapnel.setTrail(rand.nextInt(3) == 0);
            level.addFreshEntity((Entity)shrapnel);
        }
    }

    public static void spawnMissileDebris(Level level, double x, double y, double z, double motionX, double motionY, double motionZ, double deviation, List<ItemStack> debris, ItemStack rareDrop) {
        if (level.isClientSide) {
            return;
        }
        if (debris != null) {
            for (ItemStack stack : debris) {
                if (stack.isEmpty()) continue;
                int k = rand.nextInt(stack.getCount() + 1);
                for (int j = 0; j < k; ++j) {
                    ItemEntity item = new ItemEntity(level, x, y, z, stack.copy());
                    item.setDeltaMovement((motionX + rand.nextGaussian() * deviation) * 0.85, (motionY + rand.nextGaussian() * deviation) * 0.85, (motionZ + rand.nextGaussian() * deviation) * 0.85);
                    item.moveTo(item.getX() + item.getDeltaMovement().x * 2.0, item.getY() + item.getDeltaMovement().y * 2.0, item.getZ() + item.getDeltaMovement().z * 2.0);
                    level.addFreshEntity((Entity)item);
                }
            }
        }
        if (rareDrop != null && rand.nextInt(10) == 0) {
            ItemEntity item = new ItemEntity(level, x, y, z, rareDrop.copy());
            item.setDeltaMovement(motionX + rand.nextGaussian() * deviation * 0.1, motionY + rand.nextGaussian() * deviation * 0.1, motionZ + rand.nextGaussian() * deviation * 0.1);
            level.addFreshEntity((Entity)item);
        }
    }

    @Deprecated
    public static void explode(Level level, double x, double y, double z, float strength, boolean cloud, boolean rubble, boolean shrapnel, Entity exploder) {
        level.explode(exploder, x, y, z, strength, Level.ExplosionInteraction.BLOCK);
        if (cloud) {
            ExplosionLarge.spawnParticles((ServerLevel)level, x, y, z, ExplosionLarge.cloudFunction((int)strength));
        }
        if (rubble) {
            ExplosionLarge.spawnRubble(level, x, y, z, ExplosionLarge.rubbleFunction((int)strength));
        }
        if (shrapnel) {
            ExplosionLarge.spawnShrapnels(level, x, y, z, ExplosionLarge.shrapnelFunction((int)strength));
        }
    }

    @Deprecated
    public static void explode(Level level, double x, double y, double z, float strength, boolean cloud, boolean rubble, boolean shrapnel) {
        ExplosionLarge.explode(level, x, y, z, strength, cloud, rubble, shrapnel, null);
    }

    @Deprecated
    public static void explodeFire(Level level, double x, double y, double z, float strength, boolean cloud, boolean rubble, boolean shrapnel) {
        level.explode(null, x, y, z, strength, Level.ExplosionInteraction.TNT);
        if (cloud) {
            ExplosionLarge.spawnParticles((ServerLevel)level, x, y, z, ExplosionLarge.cloudFunction((int)strength));
        }
        if (rubble) {
            ExplosionLarge.spawnRubble(level, x, y, z, ExplosionLarge.rubbleFunction((int)strength));
        }
        if (shrapnel) {
            ExplosionLarge.spawnShrapnels(level, x, y, z, ExplosionLarge.shrapnelFunction((int)strength));
        }
    }

    public static void buster(Level level, double x, double y, double z, Vec3 vector, float strength, float depth) {
        vector = vector.normalize();
        int i = 0;
        while ((float)i < depth) {
            level.explode(null, x + vector.x * (double)i, y + vector.y * (double)i, z + vector.z * (double)i, strength, Level.ExplosionInteraction.BLOCK);
            i += 2;
        }
    }

    public static void jolt(Level level, double posX, double posY, double posZ, double strength, int count, double vel) {
        if (level.isClientSide) {
            return;
        }
        block0: for (int j = 0; j < count; ++j) {
            double phi = rand.nextDouble() * (Math.PI * 2);
            double costheta = rand.nextDouble() * 2.0 - 1.0;
            double theta = Math.acos(costheta);
            double x = Math.sin(theta) * Math.cos(phi);
            double y = Math.sin(theta) * Math.sin(phi);
            double z = Math.cos(theta);
            Vec3 vec = new Vec3(x, y, z);
            int i = 0;
            while ((double)i < strength) {
                float resistance;
                int bx = (int)(posX + vec.x * (double)i);
                int by = (int)(posY + vec.y * (double)i);
                int bz = (int)(posZ + vec.z * (double)i);
                BlockPos bpos = new BlockPos(bx, by, bz);
                if (level.getBlockState(bpos).getFluidState().isEmpty()) {
                    level.setBlock(bpos, Blocks.AIR.defaultBlockState(), 3);
                }
                if (!level.isEmptyBlock(bpos) && !((resistance = level.getBlockState(bpos).getBlock().getExplosionResistance(level.getBlockState(bpos), (BlockGetter)level, bpos, null)) > 70.0f)) {
                    EntityRubble rubble = (EntityRubble)((EntityType)ModEntities.RUBBLE.get()).create(level);
                    rubble.setPos((double)bx + 0.5, (double)by + 0.5, (double)bz + 0.5);
                    rubble.setMetaBasedOnBlock(level.getBlockState(bpos).getBlock());
                    Vec3 dir = new Vec3(posX - rubble.getX(), posY - rubble.getY(), posZ - rubble.getZ()).normalize();
                    rubble.setDeltaMovement(dir.x * vel, dir.y * vel, dir.z * vel);
                    level.addFreshEntity((Entity)rubble);
                    level.setBlock(bpos, Blocks.AIR.defaultBlockState(), 3);
                    continue block0;
                }
                ++i;
            }
        }
    }

    public static int cloudFunction(int i) {
        return (int)(850.0 * (1.0 - Math.pow(Math.E, (double)(-i) / 15.0)) + 15.0);
    }

    public static int rubbleFunction(int i) {
        return i / 10;
    }

    public static int shrapnelFunction(int i) {
        return i / 3;
    }
}

