/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant;

import com.hbm.explosion.vanillant.interfaces.IBlockAllocator;
import com.hbm.explosion.vanillant.interfaces.IBlockProcessor;
import com.hbm.explosion.vanillant.interfaces.IEntityProcessor;
import com.hbm.explosion.vanillant.interfaces.IExplosionSFX;
import com.hbm.explosion.vanillant.interfaces.IPlayerProcessor;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.CustomDamageHandlerAmat;
import com.hbm.explosion.vanillant.standard.EntityProcessorStandard;
import com.hbm.explosion.vanillant.standard.ExplosionEffectAmat;
import com.hbm.explosion.vanillant.standard.ExplosionEffectStandard;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ExplosionVNT {
    private IBlockAllocator blockAllocator;
    private IEntityProcessor entityProcessor;
    private IBlockProcessor blockProcessor;
    private IPlayerProcessor playerProcessor;
    private IExplosionSFX[] sfx;
    public Level level;
    public double posX;
    public double posY;
    public double posZ;
    public float size;
    public Entity exploder;
    private final Map<Player, Vec3> hitPlayers = new HashMap<Player, Vec3>();
    public Explosion compat;
    public Entity source;
    public float radius;

    public ExplosionVNT(Level level, double x, double y, double z, float size) {
        this(level, x, y, z, size, null);
    }

    public ExplosionVNT(Level level, double x, double y, double z, float size, @Nullable Entity exploder) {
        this.level = level;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.size = size;
        this.exploder = exploder;
        this.compat = new Explosion(level, exploder, x, y, z, size, false, null){

            public Map<Player, Vec3> getHitPlayers() {
                return ExplosionVNT.this.hitPlayers;
            }

            public Entity getDirectSourceEntity() {
                return ExplosionVNT.this.source;
            }

            public float radius() {
                return ExplosionVNT.this.radius;
            }
        };
    }

    public void explode() {
        this.source = this.exploder;
        this.radius = this.size;
        boolean processBlocks = this.blockAllocator != null && this.blockProcessor != null;
        boolean processEntities = this.entityProcessor != null && this.playerProcessor != null;
        HashSet<BlockPos> affectedBlocks = null;
        HashMap<Player, Vec3> affectedPlayers = null;
        if (processBlocks) {
            affectedBlocks = this.blockAllocator.allocate(this, this.level, this.posX, this.posY, this.posZ, this.size);
        }
        if (processBlocks) {
            this.compat.getToBlow().addAll(affectedBlocks);
        }
        if (processEntities) {
            affectedPlayers = this.entityProcessor.processEntities(this, this.level, this.posX, this.posY, this.posZ, this.size);
        }
        if (processEntities) {
            this.hitPlayers.putAll(affectedPlayers);
        }
        if (processBlocks) {
            this.blockProcessor.process(this, this.level, this.posX, this.posY, this.posZ, affectedBlocks);
        }
        if (processEntities) {
            this.playerProcessor.processPlayers(this, this.level, this.posX, this.posY, this.posZ, affectedPlayers);
        }
        if (this.sfx != null) {
            for (IExplosionSFX fx : this.sfx) {
                fx.doEffect(this, this.level, this.posX, this.posY, this.posZ, this.size);
            }
        }
    }

    public ExplosionVNT setBlockAllocator(IBlockAllocator blockAllocator) {
        this.blockAllocator = blockAllocator;
        return this;
    }

    public ExplosionVNT setEntityProcessor(IEntityProcessor entityProcessor) {
        this.entityProcessor = entityProcessor;
        return this;
    }

    public ExplosionVNT setBlockProcessor(IBlockProcessor blockProcessor) {
        this.blockProcessor = blockProcessor;
        return this;
    }

    public ExplosionVNT setPlayerProcessor(IPlayerProcessor playerProcessor) {
        this.playerProcessor = playerProcessor;
        return this;
    }

    public ExplosionVNT setSFX(IExplosionSFX ... sfx) {
        this.sfx = sfx;
        return this;
    }

    public ExplosionVNT makeStandard() {
        this.setBlockAllocator(new BlockAllocatorStandard());
        this.setBlockProcessor(new BlockProcessorStandard());
        this.setEntityProcessor(new EntityProcessorStandard());
        this.setPlayerProcessor(new PlayerProcessorStandard());
        this.setSFX(new ExplosionEffectStandard());
        return this;
    }

    public ExplosionVNT makeAmat() {
        this.setBlockAllocator(new BlockAllocatorStandard(this.size < 15.0f ? 16 : 32));
        this.setBlockProcessor(new BlockProcessorStandard().setNoDrop());
        this.setEntityProcessor(new EntityProcessorStandard().withRangeMod(2.0f).withDamageMod(new CustomDamageHandlerAmat(50.0f)));
        this.setPlayerProcessor(new PlayerProcessorStandard());
        this.setSFX(new ExplosionEffectAmat());
        return this;
    }
}

