/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.IBlockAllocator;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BlockAllocatorBulkie
implements IBlockAllocator {
    protected double maximum;
    protected int resolution;

    public BlockAllocatorBulkie(double maximum) {
        this(maximum, 16);
    }

    public BlockAllocatorBulkie(double maximum, int resolution) {
        this.resolution = resolution;
        this.maximum = maximum;
    }

    @Override
    public HashSet<BlockPos> allocate(ExplosionVNT explosion, Level level, double x, double y, double z, float size) {
        HashSet<BlockPos> affectedBlocks = new HashSet<BlockPos>();
        for (int i = 0; i < this.resolution; ++i) {
            for (int j = 0; j < this.resolution; ++j) {
                block2: for (int k = 0; k < this.resolution; ++k) {
                    if (i != 0 && i != this.resolution - 1 && j != 0 && j != this.resolution - 1 && k != 0 && k != this.resolution - 1) continue;
                    double d0 = (float)i / ((float)this.resolution - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)j / ((float)this.resolution - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)k / ((float)this.resolution - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double currentX = x;
                    double currentY = y;
                    double currentZ = z;
                    double dist = 0.0;
                    float stepSize = 0.3f;
                    while (dist <= (double)explosion.size) {
                        int blockZ;
                        int blockY;
                        double deltaX = currentX - x;
                        double deltaY = currentY - y;
                        double deltaZ = currentZ - z;
                        dist = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
                        int blockX = Mth.floor((double)currentX);
                        BlockPos pos = new BlockPos(blockX, blockY = Mth.floor((double)currentY), blockZ = Mth.floor((double)currentZ));
                        BlockState state = level.getBlockState(pos);
                        if (!state.isAir()) {
                            float blockResistance;
                            float f = blockResistance = explosion.exploder != null ? explosion.exploder.getBlockExplosionResistance(explosion.compat, (BlockGetter)level, pos, state, state.getFluidState(), explosion.size) : state.getExplosionResistance((BlockGetter)level, pos, explosion.compat);
                            if (this.maximum < (double)blockResistance) continue block2;
                        }
                        if (explosion.exploder == null || explosion.exploder.shouldBlockExplode(explosion.compat, (BlockGetter)level, pos, state, explosion.size)) {
                            affectedBlocks.add(pos);
                        }
                        currentX += d0 * (double)stepSize;
                        currentY += d1 * (double)stepSize;
                        currentZ += d2 * (double)stepSize;
                    }
                }
            }
        }
        return affectedBlocks;
    }
}

