/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.IBlockAllocator;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class BlockAllocatorWater
implements IBlockAllocator {
    protected int resolution;

    public BlockAllocatorWater(int resolution) {
        this.resolution = resolution;
    }

    @Override
    public HashSet<BlockPos> allocate(ExplosionVNT explosion, Level level, double x, double y, double z, float size) {
        HashSet<BlockPos> affectedBlocks = new HashSet<BlockPos>();
        for (int i = 0; i < this.resolution; ++i) {
            for (int j = 0; j < this.resolution; ++j) {
                block2: for (int k = 0; k < this.resolution; ++k) {
                    if (i != 0 && i != this.resolution - 1 && j != 0 && j != this.resolution - 1 && k != 0 && k != this.resolution - 1) continue;
                    double d0 = (float)i / ((float)this.resolution - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)j / ((float)this.resolution - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)k / ((float)this.resolution - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double currentX = x;
                    double currentY = y;
                    double currentZ = z;
                    float stepSize = 0.3f;
                    for (float powerRemaining = size * (0.7f + level.random.nextFloat() * 0.6f); powerRemaining > 0.0f; powerRemaining -= stepSize * 0.75f) {
                        int blockX = Mth.floor((double)currentX);
                        int blockY = Mth.floor((double)currentY);
                        int blockZ = Mth.floor((double)currentZ);
                        BlockPos pos = new BlockPos(blockX, blockY, blockZ);
                        BlockState state = level.getBlockState(pos);
                        FluidState fluid = level.getFluidState(pos);
                        if (!level.isInWorldBounds(pos)) continue block2;
                        if (!state.isAir() && fluid.isEmpty()) {
                            float blockResistance = explosion.exploder != null ? explosion.exploder.getBlockExplosionResistance(explosion.compat, (BlockGetter)level, pos, state, fluid, explosion.size) : state.getExplosionResistance((BlockGetter)level, pos, explosion.compat);
                            powerRemaining -= (blockResistance + 0.3f) * stepSize;
                        }
                        if (powerRemaining > 0.0f && (explosion.exploder == null || explosion.exploder.shouldBlockExplode(explosion.compat, (BlockGetter)level, pos, state, powerRemaining)) && fluid.isEmpty()) {
                            affectedBlocks.add(pos);
                        }
                        currentX += d0 * (double)stepSize;
                        currentY += d1 * (double)stepSize;
                        currentZ += d2 * (double)stepSize;
                    }
                }
            }
        }
        return affectedBlocks;
    }
}

