/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.ICustomDamageHandler;
import com.hbm.explosion.vanillant.interfaces.IEntityProcessor;
import com.hbm.explosion.vanillant.interfaces.IEntityRangeMutator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class EntityProcessorCross
implements IEntityProcessor {
    protected double nodeDist;
    protected IEntityRangeMutator range;
    protected ICustomDamageHandler damage;
    protected double knockbackMult = 1.0;
    protected boolean allowSelfDamage = false;

    public EntityProcessorCross(double nodeDist) {
        this.nodeDist = nodeDist;
    }

    public EntityProcessorCross setAllowSelfDamage() {
        this.allowSelfDamage = true;
        return this;
    }

    public EntityProcessorCross setKnockback(double mult) {
        this.knockbackMult = mult;
        return this;
    }

    @Override
    public HashMap<Player, Vec3> processEntities(ExplosionVNT explosion, Level level, double x, double y, double z, float size) {
        HashMap<Player, Vec3> affectedPlayers = new HashMap<Player, Vec3>();
        size *= 2.0f;
        if (this.range != null) {
            size = this.range.mutateRange(explosion, size);
        }
        double minX = x - (double)size - 1.0;
        double maxX = x + (double)size + 1.0;
        double minY = y - (double)size - 1.0;
        double maxY = y + (double)size + 1.0;
        double minZ = z - (double)size - 1.0;
        double maxZ = z + (double)size + 1.0;
        List list = level.getEntities(this.allowSelfDamage ? null : explosion.exploder, new AABB(minX, minY, minZ, maxX, maxY, maxZ));
        EventHooks.onExplosionDetonate((Level)level, (Explosion)explosion.compat, (List)list, (double)size);
        Vec3[] nodes = new Vec3[7];
        for (int i = 0; i < 7; ++i) {
            Direction dir = Direction.from3DDataValue((int)i);
            nodes[i] = new Vec3(x + (double)dir.getStepX() * this.nodeDist, y + (double)dir.getStepY() * this.nodeDist, z + (double)dir.getStepZ() * this.nodeDist);
        }
        HashMap<Entity, Float> damageMap = new HashMap<Entity, Float>();
        for (int index = 0; index < list.size(); ++index) {
            double deltaZ;
            double deltaY;
            double deltaX;
            double distance;
            double zDist;
            double yDist;
            Entity entity = (Entity)list.get(index);
            AABB entityBoundingBox = entity.getBoundingBox();
            double xDist = entityBoundingBox.minX <= x && entityBoundingBox.maxX >= x ? 0.0 : Math.min(Math.abs(entityBoundingBox.minX - x), Math.abs(entityBoundingBox.maxX - x));
            double dist = Math.sqrt(xDist * xDist + (yDist = entityBoundingBox.minY <= y && entityBoundingBox.maxY >= y ? 0.0 : Math.min(Math.abs(entityBoundingBox.minY - y), Math.abs(entityBoundingBox.maxY - y))) * yDist + (zDist = entityBoundingBox.minZ <= z && entityBoundingBox.maxZ >= z ? 0.0 : Math.min(Math.abs(entityBoundingBox.minZ - z), Math.abs(entityBoundingBox.maxZ - z))) * zDist);
            double distanceScaled = dist / (double)size;
            if (!(distanceScaled <= 1.0) || (distance = Math.sqrt((deltaX = entity.getX() - x) * deltaX + (deltaY = entity.getY() + (double)entity.getEyeHeight() - y) * deltaY + (deltaZ = entity.getZ() - z) * deltaZ)) == 0.0) continue;
            deltaX /= distance;
            deltaY /= distance;
            deltaZ /= distance;
            double density = 0.0;
            for (Vec3 vec : nodes) {
                double d = Explosion.getSeenPercent((Vec3)vec, (Entity)entity);
                if (!(d > density)) continue;
                density = d;
            }
            double knockback = (1.0 - distanceScaled) * density;
            float dmg = this.calculateDamage(distanceScaled, density, knockback, size);
            if (!damageMap.containsKey(entity) || ((Float)damageMap.get(entity)).floatValue() < dmg) {
                damageMap.put(entity, Float.valueOf(dmg));
            }
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            affectedPlayers.put(player, new Vec3(deltaX * knockback * this.knockbackMult, deltaY * knockback * this.knockbackMult, deltaZ * knockback * this.knockbackMult));
        }
        for (Map.Entry entry : damageMap.entrySet()) {
            Entity entity = (Entity)entry.getKey();
            this.attackEntity(entity, explosion, ((Float)entry.getValue()).floatValue());
            if (this.damage == null) continue;
            AABB entityBoundingBox = entity.getBoundingBox();
            double xDist = entityBoundingBox.minX <= x && entityBoundingBox.maxX >= x ? 0.0 : Math.min(Math.abs(entityBoundingBox.minX - x), Math.abs(entityBoundingBox.maxX - x));
            double yDist = entityBoundingBox.minY <= y && entityBoundingBox.maxY >= y ? 0.0 : Math.min(Math.abs(entityBoundingBox.minY - y), Math.abs(entityBoundingBox.maxY - y));
            double zDist = entityBoundingBox.minZ <= z && entityBoundingBox.maxZ >= z ? 0.0 : Math.min(Math.abs(entityBoundingBox.minZ - z), Math.abs(entityBoundingBox.maxZ - z));
            double dist = Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist);
            double distanceScaled = dist / (double)size;
            this.damage.handleAttack(explosion, entity, distanceScaled);
        }
        return affectedPlayers;
    }

    public void attackEntity(Entity entity, ExplosionVNT source, float amount) {
        entity.hurt(EntityProcessorCross.setExplosionSource(entity.level(), source.compat), amount);
    }

    public float calculateDamage(double distanceScaled, double density, double knockback, float size) {
        return (int)((knockback * knockback + knockback) / 2.0 * 8.0 * (double)size + 1.0);
    }

    public static DamageSource setExplosionSource(Level level, Explosion explosion) {
        DamageSources sources = level.damageSources();
        LivingEntity causing = explosion.getIndirectSourceEntity();
        Entity direct = explosion.getDirectSourceEntity();
        return sources.explosion((Entity)causing, direct);
    }

    public EntityProcessorCross withRangeMod(final float mod) {
        this.range = new IEntityRangeMutator(){

            @Override
            public float mutateRange(ExplosionVNT explosion, float range) {
                return range * mod;
            }
        };
        return this;
    }

    public EntityProcessorCross withDamageMod(ICustomDamageHandler damage) {
        this.damage = damage;
        return this;
    }
}

