/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.EntityProcessorCross;
import com.hbm.items.weapon.sedna.DamageSourceSednaNoAttacker;
import com.hbm.items.weapon.sedna.DamageSourceSednaWithAttacker;
import com.hbm.items.weapon.sedna.factory.ConfettiUtil;
import com.hbm.util.DamageResistanceHandler;
import com.hbm.util.EntityDamageUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntityProcessorCrossSmooth
extends EntityProcessorCross {
    protected float fixedDamage;
    protected float pierceDT = 0.0f;
    protected float pierceDR = 0.0f;
    protected DamageResistanceHandler.DamageClass clazz = DamageResistanceHandler.DamageClass.EXPLOSION;

    public EntityProcessorCrossSmooth(double nodeDist, float fixedDamage) {
        super(nodeDist);
        this.fixedDamage = fixedDamage;
        this.setAllowSelfDamage();
    }

    public EntityProcessorCrossSmooth setupPiercing(float pierceDT, float pierceDR) {
        this.pierceDT = pierceDT;
        this.pierceDR = pierceDR;
        return this;
    }

    public EntityProcessorCrossSmooth setDamageClass(DamageResistanceHandler.DamageClass clazz) {
        this.clazz = clazz;
        return this;
    }

    @Override
    public void attackEntity(Entity entity, ExplosionVNT source, float amount) {
        if (!entity.isAlive()) {
            return;
        }
        if (source.exploder == entity) {
            amount *= 0.5f;
        }
        DamageSourceSednaNoAttacker dmg = EntityProcessorCrossSmooth.getDamage(entity.level(), null, source.exploder instanceof LivingEntity ? (LivingEntity)source.exploder : null, this.clazz);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityDamageUtil.hurtNT(livingEntity, dmg, amount, true, false, 0.0, this.pierceDT, this.pierceDR);
            if (!entity.isAlive()) {
                ConfettiUtil.decideConfetti(livingEntity, dmg);
            }
        } else {
            entity.hurt((DamageSource)dmg, amount);
        }
    }

    @Override
    public float calculateDamage(double distanceScaled, double density, double knockback, float size) {
        if (density < 0.125) {
            return 0.0f;
        }
        return (float)((double)this.fixedDamage * (1.0 - distanceScaled));
    }

    public static DamageSourceSednaNoAttacker getDamage(Level level, Entity projectile, LivingEntity shooter, DamageResistanceHandler.DamageClass dmgClass) {
        DamageSourceSednaNoAttacker dmg = shooter != null ? new DamageSourceSednaWithAttacker(dmgClass.name(), projectile, (Entity)shooter) : new DamageSourceSednaNoAttacker(level, dmgClass.name());
        switch (dmgClass) {
            case PHYSICAL: {
                dmg.setProjectile();
                break;
            }
            case IN_FIRE: {
                dmg.setFireDamage();
                break;
            }
            case EXPLOSION: {
                dmg.setExplosion();
                break;
            }
        }
        return dmg;
    }
}

