/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.ICustomDamageHandler;
import com.hbm.explosion.vanillant.interfaces.IEntityProcessor;
import com.hbm.explosion.vanillant.interfaces.IEntityRangeMutator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class EntityProcessorStandard
implements IEntityProcessor {
    protected IEntityRangeMutator range;
    protected ICustomDamageHandler damage;
    protected boolean allowSelfDamage = false;

    @Override
    public HashMap<Player, Vec3> processEntities(ExplosionVNT explosion, Level level, double x, double y, double z, float size) {
        HashMap<Player, Vec3> affectedPlayers = new HashMap<Player, Vec3>();
        size *= 2.0f;
        if (this.range != null) {
            size = this.range.mutateRange(explosion, size);
        }
        double minX = x - (double)size - 1.0;
        double maxX = x + (double)size + 1.0;
        double minY = y - (double)size - 1.0;
        double maxY = y + (double)size + 1.0;
        double minZ = z - (double)size - 1.0;
        double maxZ = z + (double)size + 1.0;
        List list = level.getEntities(this.allowSelfDamage ? null : explosion.exploder, new AABB(minX, minY, minZ, maxX, maxY, maxZ));
        EventHooks.onExplosionDetonate((Level)level, (Explosion)explosion.compat, (List)list, (double)size);
        Vec3 vec3 = new Vec3(x, y, z);
        for (int index = 0; index < list.size(); ++index) {
            double deltaZ;
            double deltaY;
            double deltaX;
            double distance;
            Entity entity = (Entity)list.get(index);
            double distanceScaled = entity.distanceToSqr(x, y, z) / (double)size;
            if (!(distanceScaled <= 1.0) || (distance = Math.sqrt((deltaX = entity.getX() - x) * deltaX + (deltaY = entity.getY() + (double)entity.getEyeHeight() - y) * deltaY + (deltaZ = entity.getZ() - z) * deltaZ)) == 0.0) continue;
            deltaX /= distance;
            deltaY /= distance;
            deltaZ /= distance;
            double density = Explosion.getSeenPercent((Vec3)vec3, (Entity)entity);
            double knockback = (1.0 - distanceScaled) * density;
            entity.hurt(EntityProcessorStandard.setExplosionSource(level, explosion.compat), this.calculateDamage(distanceScaled, density, knockback, size));
            if (entity instanceof Player) {
                Player player = (Player)entity;
                affectedPlayers.put(player, new Vec3(deltaX * knockback, deltaY * knockback, deltaZ * knockback));
            }
            if (this.damage == null) continue;
            this.damage.handleAttack(explosion, entity, distanceScaled);
        }
        return affectedPlayers;
    }

    public float calculateDamage(double distanceScaled, double density, double knockback, float size) {
        return (int)((knockback * knockback + knockback) / 2.0 * 8.0 * (double)size + 1.0);
    }

    public static DamageSource setExplosionSource(Level level, Explosion explosion) {
        DamageSources sources = level.damageSources();
        LivingEntity causing = explosion.getIndirectSourceEntity();
        Entity direct = explosion.getDirectSourceEntity();
        return sources.explosion((Entity)causing, direct);
    }

    public EntityProcessorStandard withRangeMod(final float mod) {
        this.range = new IEntityRangeMutator(){

            @Override
            public float mutateRange(ExplosionVNT explosion, float range) {
                return range * mod;
            }
        };
        return this;
    }

    public EntityProcessorStandard withDamageMod(ICustomDamageHandler damage) {
        this.damage = damage;
        return this;
    }

    public EntityProcessorStandard allowSelfDamage() {
        this.allowSelfDamage = true;
        return this;
    }
}

