/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.extprop;

import com.hbm.config.MainConfig;
import com.hbm.entity.mob.Duck;
import com.hbm.lib.ModAttachments;
import com.hbm.lib.ModDamageSource;
import com.hbm.network.toclient.InformPlayerPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.network.PacketDistributor;

public class LivingProperties {
    public LivingEntity entity;
    private static final ResourceLocation DIGAMMA_MOD = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"digamma");
    private float radiation;
    private float digamma;
    private int asbestos;
    public static final int maxAsbestos = 72000;
    private int blacklung;
    public static final int maxBlacklung = 144000;
    private float radEnv;
    private float radBuf;
    private int bombTimer;
    private int contagion;
    private int oil;
    public int fire;
    public int phosphorus;
    public int balefire;
    public int blackFire;
    private final List<ContaminationEffect> contamination = new ArrayList<ContaminationEffect>();

    public LivingProperties(IAttachmentHolder iAttachmentHolder) {
        if (iAttachmentHolder instanceof LivingEntity) {
            LivingEntity livingEntity;
            this.entity = livingEntity = (LivingEntity)iAttachmentHolder;
        }
    }

    public static LivingProperties getData(LivingEntity entity) {
        return (LivingProperties)entity.getData(ModAttachments.LIVING_PROPS);
    }

    public static float getRadiation(LivingEntity entity) {
        if (!((Boolean)MainConfig.COMMON.ENABLE_CONTAMINATION.get()).booleanValue()) {
            return 0.0f;
        }
        return LivingProperties.getData((LivingEntity)entity).radiation;
    }

    public static void setRadiation(LivingEntity entity, float rad) {
        if (((Boolean)MainConfig.COMMON.ENABLE_CONTAMINATION.get()).booleanValue()) {
            LivingProperties.getData((LivingEntity)entity).radiation = rad;
        }
    }

    public static void incrementRadiation(LivingEntity entity, float rad) {
        if (!((Boolean)MainConfig.COMMON.ENABLE_CONTAMINATION.get()).booleanValue()) {
            return;
        }
        float radiation = LivingProperties.getData((LivingEntity)entity).radiation + rad;
        if (radiation > 2500.0f) {
            radiation = 2500.0f;
        }
        if (radiation < 0.0f) {
            radiation = 0.0f;
        }
        LivingProperties.setRadiation(entity, radiation);
    }

    public static float getRadEnv(LivingEntity entity) {
        return LivingProperties.getData((LivingEntity)entity).radEnv;
    }

    public static void setRadEnv(LivingEntity entity, float rad) {
        LivingProperties.getData((LivingEntity)entity).radEnv = rad;
    }

    public static float getRadBuf(LivingEntity entity) {
        return LivingProperties.getData((LivingEntity)entity).radBuf;
    }

    public static void setRadBuf(LivingEntity entity, float rad) {
        LivingProperties.getData((LivingEntity)entity).radBuf = rad;
    }

    public static List<ContaminationEffect> getCont(LivingEntity entity) {
        return LivingProperties.getData((LivingEntity)entity).contamination;
    }

    public static void addCont(LivingEntity entity, ContaminationEffect cont) {
        LivingProperties.getData((LivingEntity)entity).contamination.add(cont);
    }

    public static float getDigamma(LivingEntity entity) {
        return LivingProperties.getData((LivingEntity)entity).digamma;
    }

    public static void setDigamma(LivingEntity entity, float digamma) {
        if (entity.level().isClientSide) {
            return;
        }
        if (entity instanceof Duck) {
            digamma = 0.0f;
        }
        LivingProperties.getData((LivingEntity)entity).digamma = digamma;
        float healthMod = (float)Math.pow(0.5, digamma) - 1.0f;
        AttributeInstance attributeInstance = entity.getAttribute(Attributes.MAX_HEALTH);
        if (attributeInstance != null) {
            attributeInstance.removeModifier(DIGAMMA_MOD);
            AttributeModifier modifier = new AttributeModifier(DIGAMMA_MOD, (double)healthMod, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            attributeInstance.addPermanentModifier(modifier);
            if (entity.getHealth() > entity.getMaxHealth() && entity.getMaxHealth() > 0.0f) {
                entity.setHealth(entity.getMaxHealth());
            }
        }
        if ((entity.getMaxHealth() <= 0.0f || digamma >= 10.0f) && entity.isAlive()) {
            DamageSource src = new DamageSource((Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ModDamageSource.DIGAMMA));
            entity.hurt(src, Float.MAX_VALUE);
        }
    }

    public static void incrementDigamma(LivingEntity entity, float digamma) {
        float dRad;
        if (entity instanceof Duck) {
            digamma = 0.0f;
        }
        if ((dRad = LivingProperties.getDigamma(entity) + digamma) > 10.0f) {
            dRad = 10.0f;
        }
        if (dRad < 0.0f) {
            dRad = 0.0f;
        }
        LivingProperties.setDigamma(entity, dRad);
    }

    public static int getAsbestos(LivingEntity entity) {
        if (((Boolean)MainConfig.COMMON.DISABLE_ASBESTOS.get()).booleanValue()) {
            return 0;
        }
        return LivingProperties.getData((LivingEntity)entity).asbestos;
    }

    public static void setAsbestos(LivingEntity entity, int asbestos) {
        if (((Boolean)MainConfig.COMMON.DISABLE_ASBESTOS.get()).booleanValue()) {
            return;
        }
        LivingProperties.getData((LivingEntity)entity).asbestos = asbestos;
        if (asbestos >= 72000) {
            LivingProperties.getData((LivingEntity)entity).asbestos = 0;
            DamageSource src = new DamageSource((Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ModDamageSource.ASBESTOS));
            entity.hurt(src, Float.MAX_VALUE);
        }
    }

    public static void incrementAsbestos(LivingEntity entity, int asbestos) {
        if (((Boolean)MainConfig.COMMON.DISABLE_ASBESTOS.get()).booleanValue()) {
            return;
        }
        LivingProperties.setAsbestos(entity, LivingProperties.getAsbestos(entity) + asbestos);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MutableComponent comp = Component.translatable((String)"info.asbestos").withStyle(ChatFormatting.RED);
            InformPlayerPacket packet = new InformPlayerPacket(true, null, (Component)comp, 12, 3000);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static int getBlackLung(LivingEntity entity) {
        if (((Boolean)MainConfig.COMMON.DISABLE_COAL.get()).booleanValue()) {
            return 0;
        }
        return LivingProperties.getData((LivingEntity)entity).blacklung;
    }

    public static void setBlackLung(LivingEntity entity, int blacklung) {
        if (((Boolean)MainConfig.COMMON.DISABLE_COAL.get()).booleanValue()) {
            return;
        }
        LivingProperties.getData((LivingEntity)entity).blacklung = blacklung;
        if (blacklung >= 144000) {
            LivingProperties.getData((LivingEntity)entity).blacklung = 0;
            DamageSource src = new DamageSource((Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ModDamageSource.BLACKLUNG));
            entity.hurt(src, Float.MAX_VALUE);
        }
    }

    public static void incrementBlackLung(LivingEntity entity, int blacklung) {
        if (((Boolean)MainConfig.COMMON.DISABLE_COAL.get()).booleanValue()) {
            return;
        }
        LivingProperties.setBlackLung(entity, LivingProperties.getBlackLung(entity) + blacklung);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MutableComponent comp = Component.translatable((String)"info.coaldust").withStyle(ChatFormatting.RED);
            InformPlayerPacket packet = new InformPlayerPacket(true, null, (Component)comp, 12, 3000);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static int getTimer(LivingEntity entity) {
        return LivingProperties.getData((LivingEntity)entity).bombTimer;
    }

    public static void setTimer(LivingEntity entity, int bombTimer) {
        LivingProperties.getData((LivingEntity)entity).bombTimer = bombTimer;
    }

    public static int getContagion(LivingEntity entity) {
        return LivingProperties.getData((LivingEntity)entity).contagion;
    }

    public static void setContagion(LivingEntity entity, int contagion) {
        LivingProperties.getData((LivingEntity)entity).contagion = contagion;
    }

    public static int getOil(LivingEntity entity) {
        return LivingProperties.getData((LivingEntity)entity).oil;
    }

    public static void setOil(LivingEntity entity, int oil) {
        LivingProperties.getData((LivingEntity)entity).oil = oil;
    }

    private static boolean isCreative(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (player.isSpectator()) {
            return true;
        }
        return player.isCreative();
    }

    public CompoundTag serializeNBT() {
        CompoundTag props = new CompoundTag();
        props.putFloat("hfr_radiation", this.radiation);
        props.putFloat("hfr_digamma", this.digamma);
        props.putInt("hfr_asbestos", this.asbestos);
        props.putInt("hfr_bomb", this.bombTimer);
        props.putInt("hfr_contagion", this.contagion);
        props.putInt("hfr_blacklung", this.blacklung);
        props.putInt("hfr_oil", this.oil);
        props.putInt("hfr_fire", this.fire);
        props.putInt("hfr_phosphorus", this.phosphorus);
        props.putInt("hfr_balefire", this.balefire);
        props.putInt("hfr_blackfire", this.blackFire);
        props.putInt("hfr_cont_count", this.contamination.size());
        for (int i = 0; i < this.contamination.size(); ++i) {
            this.contamination.get(i).save(props, i);
        }
        return props;
    }

    public void deserializeNBT(CompoundTag props) {
        if (props != null) {
            this.radiation = props.getFloat("hfr_radiation");
            this.digamma = props.getFloat("hfr_digamma");
            this.asbestos = props.getInt("hfr_asbestos");
            this.bombTimer = props.getInt("hfr_bomb");
            this.contagion = props.getInt("hfr_contagion");
            this.blacklung = props.getInt("hfr_blacklung");
            this.oil = props.getInt("hfr_oil");
            this.fire = props.getInt("hfr_fire");
            this.phosphorus = props.getInt("hfr_phosphorus");
            this.balefire = props.getInt("hfr_balefire");
            this.blackFire = props.getInt("hfr_blackfire");
            int cont = props.getInt("hfr_cont_count");
            this.contamination.clear();
            for (int i = 0; i < cont; ++i) {
                this.contamination.add(ContaminationEffect.load(props, i));
            }
        }
    }

    public static class ContaminationEffect {
        public float maxRad;
        public int maxTime;
        public int time;
        public boolean ignoreArmor;

        public ContaminationEffect(float rad, int time, boolean ignoreArmor) {
            this.maxRad = rad;
            this.maxTime = this.time = time;
            this.ignoreArmor = ignoreArmor;
        }

        public float getRad() {
            return this.maxRad * ((float)this.time / (float)this.maxTime);
        }

        public void save(CompoundTag nbt, int index) {
            CompoundTag me = new CompoundTag();
            me.putFloat("maxRad", this.maxRad);
            me.putInt("maxTime", this.maxTime);
            me.putInt("time", this.time);
            me.putBoolean("ignoreArmor", this.ignoreArmor);
            nbt.put("cont_" + index, (Tag)me);
        }

        public static ContaminationEffect load(CompoundTag nbt, int index) {
            CompoundTag me = (CompoundTag)nbt.get("cont_" + index);
            assert (me != null);
            float maxRad = me.getFloat("maxRad");
            int maxTime = me.getInt("maxTime");
            int time = me.getInt("time");
            boolean ignoreArmor = me.getBoolean("ignoreArmor");
            ContaminationEffect effect = new ContaminationEffect(maxRad, maxTime, ignoreArmor);
            effect.time = time;
            return effect;
        }
    }
}

