/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.extprop;

import com.hbm.handler.Keybinds;
import com.hbm.lib.ModAttachments;
import com.hbm.network.toclient.InformPlayerPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlayerProperties {
    public Player player;
    public boolean hasReceivedBook = false;
    public boolean enableHUD = true;
    public boolean enableBackpack = true;
    public boolean enableMagnet = true;
    private final boolean[] keysPressed = new boolean[Keybinds.EnumKeybind.values().length];
    public boolean dashActivated = true;
    public static final int dashCooldownLength = 5;
    public int dashCooldown = 0;
    public int totalDashCount = 0;
    public int stamina = 0;
    public static final int plinkCooldownLength = 10;
    public int plinkCooldown = 0;
    public float shield = 0.0f;
    public float maxShield = 0.0f;
    public int lastDamage = 0;
    public static final float shieldCap = 100.0f;
    public int reputation;
    public boolean isOnLadder = false;

    public PlayerProperties(IAttachmentHolder iAttachmentHolder) {
        if (iAttachmentHolder instanceof Player) {
            Player holder;
            this.player = holder = (Player)iAttachmentHolder;
        }
    }

    public static PlayerProperties getData(Player player) {
        return (PlayerProperties)player.getData(ModAttachments.PLAYER_PROPS);
    }

    public boolean getKeyPressed(Keybinds.EnumKeybind key) {
        return this.keysPressed[key.ordinal()];
    }

    public boolean isJetpackActive() {
        return this.enableBackpack && this.getKeyPressed(Keybinds.EnumKeybind.JETPACK);
    }

    public boolean isMagnetActive() {
        return this.enableMagnet;
    }

    public void setKeyPressed(Keybinds.EnumKeybind key, boolean pressed) {
        if (!this.getKeyPressed(key) && pressed) {
            if (key == Keybinds.EnumKeybind.TOGGLE_JETPACK && !this.player.level().isClientSide) {
                boolean bl = this.enableBackpack = !this.enableBackpack;
                if (this.enableBackpack) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new InformPlayerPacket(true, null, (Component)Component.literal((String)"Jetpack ON").withStyle(ChatFormatting.GREEN), 5, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new InformPlayerPacket(true, null, (Component)Component.literal((String)"Jetpack OFF").withStyle(ChatFormatting.RED), 5, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (key == Keybinds.EnumKeybind.TOGGLE_MAGNET && !this.player.level().isClientSide) {
                boolean bl = this.enableMagnet = !this.enableMagnet;
                if (this.enableMagnet) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new InformPlayerPacket(true, null, (Component)Component.literal((String)"Magnet ON").withStyle(ChatFormatting.GREEN), 6, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new InformPlayerPacket(true, null, (Component)Component.literal((String)"Magnet OFF").withStyle(ChatFormatting.RED), 6, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (key == Keybinds.EnumKeybind.TOGGLE_HEAD && !this.player.level().isClientSide) {
                boolean bl = this.enableHUD = !this.enableHUD;
                if (this.enableHUD) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new InformPlayerPacket(true, null, (Component)Component.literal((String)"HUD ON").withStyle(ChatFormatting.GREEN), 7, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new InformPlayerPacket(true, null, (Component)Component.literal((String)"HUD OFF").withStyle(ChatFormatting.RED), 7, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
        this.keysPressed[key.ordinal()] = pressed;
    }

    public void setDashCooldown(int cooldown) {
        this.dashCooldown = cooldown;
    }

    public int getDashCooldown() {
        return this.dashCooldown;
    }

    public void setStamina(int stamina) {
        this.stamina = stamina;
    }

    public int getStamina() {
        return this.stamina;
    }

    public void setDashCount(int count) {
        this.totalDashCount = count;
    }

    public int getDashCount() {
        return this.totalDashCount;
    }

    public CompoundTag serializeNBT() {
        CompoundTag props = new CompoundTag();
        props.putBoolean("hasReceivedBook", this.hasReceivedBook);
        props.putFloat("shield", this.shield);
        props.putFloat("maxShield", this.maxShield);
        props.putBoolean("enableBackpack", this.enableBackpack);
        props.putBoolean("enableHUD", this.enableHUD);
        props.putInt("reputation", this.reputation);
        props.putBoolean("isOnLadder", this.isOnLadder);
        props.putBoolean("enableMagnet", this.enableMagnet);
        return props;
    }

    public void deserializeNBT(CompoundTag props) {
        if (props != null) {
            this.hasReceivedBook = props.getBoolean("hasReceivedBook");
            this.shield = props.getFloat("shield");
            this.maxShield = props.getFloat("maxShield");
            this.enableBackpack = props.getBoolean("enableBackpack");
            this.enableHUD = props.getBoolean("enableHUD");
            this.reputation = props.getInt("reputation");
            this.isOnLadder = props.getBoolean("isOnLadder");
            this.enableMagnet = props.getBoolean("enableMagnet");
        }
    }
}

