/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.items.IKeybindReceiver;
import com.hbm.network.toserver.KeybindReceiver;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="hbmsntm", value={Dist.CLIENT})
public class Keybinds {
    private static final String category = "hbmsntm.keys";
    public static final KeyMapping JETPACK = new KeyMapping("hbmsntm.keys.toggleBack", InputConstants.Type.KEYSYM, 86, "hbmsntm.keys");
    public static final KeyMapping MAGNET = new KeyMapping("hbmsntm.keys.toggleMagnet", InputConstants.Type.KEYSYM, 90, "hbmsntm.keys");
    public static final KeyMapping HUD = new KeyMapping("hbmsntm.keys.toggleHUD", InputConstants.Type.KEYSYM, 88, "hbmsntm.keys");
    public static final KeyMapping ABILITY_CYCLE = new KeyMapping("hbmsntm.keys.ability", InputConstants.Type.MOUSE, 1, "hbmsntm.keys");
    public static final KeyMapping ABILITY_ALT = new KeyMapping("hbmsntm.keys.abilityAlt", InputConstants.Type.KEYSYM, 342, "hbmsntm.keys");
    public static final KeyMapping COPY_TOOL_ALT = new KeyMapping("hbmsntm.keys.copyToolAlt", InputConstants.Type.KEYSYM, 342, "hbmsntm.keys");
    public static final KeyMapping COPY_TOOL_CTRL = new KeyMapping("hbmsntm.keys.copyToolCtrl", InputConstants.Type.KEYSYM, 341, "hbmsntm.keys");
    private static final Map<KeyMapping, EnumKeybind> CONNECTED_BINDS = new HashMap<KeyMapping, EnumKeybind>();

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        Keybinds.register(event, JETPACK, EnumKeybind.TOGGLE_JETPACK);
        Keybinds.register(event, MAGNET, EnumKeybind.TOGGLE_MAGNET);
        Keybinds.register(event, HUD, EnumKeybind.TOGGLE_HEAD);
        Keybinds.register(event, ABILITY_CYCLE, EnumKeybind.ABILITY_CYCLE);
        Keybinds.register(event, ABILITY_ALT, EnumKeybind.ABILITY_ALT);
        Keybinds.register(event, COPY_TOOL_ALT, EnumKeybind.TOOL_ALT);
        Keybinds.register(event, COPY_TOOL_CTRL, EnumKeybind.TOOL_CTRL);
    }

    private static void register(RegisterKeyMappingsEvent event, KeyMapping mapping, EnumKeybind logical) {
        event.register(mapping);
        CONNECTED_BINDS.put(mapping, logical);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        for (Map.Entry<KeyMapping, EnumKeybind> entry : CONNECTED_BINDS.entrySet()) {
            KeyMapping mapping = entry.getKey();
            EnumKeybind enumKeybind = entry.getValue();
            if (!mapping.matches(event.getKey(), event.getScanCode()) || event.getAction() != 1 && event.getAction() != 0) continue;
            boolean isPressed = event.getAction() == 1;
            PacketDistributor.sendToServer((CustomPacketPayload)new KeybindReceiver(enumKeybind, isPressed, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Keybinds.handleKeybindReceiver((Player)Minecraft.getInstance().player, enumKeybind, isPressed);
        }
    }

    private static void handleKeybindReceiver(Player player, EnumKeybind key, boolean state) {
        if (player == null) {
            return;
        }
        for (ItemStack stack : new ItemStack[]{player.getMainHandItem(), player.getOffhandItem()}) {
            IKeybindReceiver receiver;
            Item item = stack.getItem();
            if (!(item instanceof IKeybindReceiver) || !(receiver = (IKeybindReceiver)item).canHandleKeybind(player, stack, key)) continue;
            receiver.handleKeybindClient(player, stack, key, state);
            PacketDistributor.sendToServer((CustomPacketPayload)new KeybindReceiver(key, state, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static enum EnumKeybind {
        JETPACK,
        TOGGLE_JETPACK,
        TOGGLE_MAGNET,
        TOGGLE_HEAD,
        DASH,
        TRAIN,
        CRANE_UP,
        CRANE_DOWN,
        CRANE_LEFT,
        CRANE_RIGHT,
        CRANE_LOAD,
        ABILITY_CYCLE,
        ABILITY_ALT,
        TOOL_ALT,
        TOOL_CTRL,
        GUN_PRIMARY,
        GUN_SECONDARY,
        GUN_TERTIARY,
        RELOAD;

    }
}

