/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.gui;

import com.hbm.items.tools.GeigerCounterItem;
import com.hbm.network.toserver.GetRadPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class GeigerGUI {
    private static final int UPDATE_INTERVAL_TICKS = 10;
    private static long prevTick = -1L;
    private static float prevRad = 0.0f;
    private static float smoothedRadiation = 0.0f;
    public static float rad;
    public static final ResourceLocation MISC_TEXTURE;

    private static int getScaled(double cur, double max, double scale) {
        return (int)Math.min(cur / max * scale, scale);
    }

    public static void RegisterGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.parse((String)"geiger_gui"), (guiGraphics, partialTick) -> {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            GeigerGUI.renderRadCounter(guiGraphics, mc.font, (Player)player);
        });
    }

    public static void renderRadCounter(GuiGraphics guiGraphics, Font font, Player player) {
        long ticksPassed;
        if (!GeigerGUI.checkForGeiger((LocalPlayer)player)) {
            return;
        }
        if (Minecraft.getInstance().level == null) {
            return;
        }
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        guiGraphics.pose().pushPose();
        GeigerGUI.getRad(player.getUUID());
        long currentTick = Minecraft.getInstance().level.getGameTime();
        if (prevTick < 0L) {
            prevTick = currentTick;
            prevRad = rad;
        }
        if ((ticksPassed = currentTick - prevTick) >= 10L) {
            float secondsPassed = (float)ticksPassed / 20.0f;
            smoothedRadiation = (rad - prevRad) / secondsPassed;
            prevTick = currentTick;
            prevRad = rad;
        }
        int length = 74;
        int maxRad = 1000;
        int bar = GeigerGUI.getScaled(rad, maxRad, length);
        int posX = 16;
        int posY = guiGraphics.guiHeight() - 20;
        guiGraphics.blit(MISC_TEXTURE, posX, posY, 0, 0, 94, 18);
        guiGraphics.blit(MISC_TEXTURE, posX + 1, posY + 1, 1, 19, bar, 16);
        if (smoothedRadiation >= 25.0f) {
            guiGraphics.blit(MISC_TEXTURE, posX + length + 2, posY - 18, 36, 36, 18, 18);
        } else if (smoothedRadiation >= 10.0f) {
            guiGraphics.blit(MISC_TEXTURE, posX + length + 2, posY - 18, 18, 36, 18, 18);
        } else if ((double)smoothedRadiation >= 2.5) {
            guiGraphics.blit(MISC_TEXTURE, posX + length + 2, posY - 18, 0, 36, 18, 18);
        }
        String radText = "";
        if (smoothedRadiation > 1000.0f) {
            radText = ">1000 RAD/s";
        } else if (smoothedRadiation >= 0.1f) {
            radText = String.format("%.1f RAD/s", Float.valueOf(smoothedRadiation));
        } else if (smoothedRadiation > 0.0f) {
            radText = "<0.1 RAD/s";
        }
        if (!radText.isEmpty()) {
            guiGraphics.drawString(font, radText, posX, posY - 8, 0xFF0000, false);
        }
        guiGraphics.pose().popPose();
    }

    private static boolean checkForGeiger(LocalPlayer player) {
        if (player.getOffhandItem().getItem() instanceof GeigerCounterItem) {
            return true;
        }
        for (ItemStack stack : player.getInventory().items) {
            if (!(stack.getItem() instanceof GeigerCounterItem)) continue;
            return true;
        }
        return false;
    }

    public static void getRadFromServer(float rad) {
        GeigerGUI.rad = rad;
    }

    private static void getRad(UUID target) {
        PacketDistributor.sendToServer((CustomPacketPayload)new GetRadPacket(target), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    static {
        MISC_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/misc/overlay_misc.png");
    }
}

