/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.HBMsNTMClient;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.MainConfig;
import com.hbm.handler.radiation.ChunkRadiationHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

public class ChunkRadiationHandlerSimple
extends ChunkRadiationHandler {
    private final HashMap<Level, SimpleRadiationPerWorld> perWorld = new HashMap();
    private static final float maxRad = 100000.0f;
    private static final String NBT_KEY_CHUNK_RADIATION = "hfr_simple_radiation";

    @Override
    public float getRadiation(Level level, int x, int y, int z) {
        SimpleRadiationPerWorld radWorld = this.perWorld.get(level);
        if (radWorld != null) {
            ChunkPos coords = new ChunkPos(x >> 4, z >> 4);
            Float rad = radWorld.radiation.get(coords);
            return rad == null ? 0.0f : Mth.clamp((float)rad.floatValue(), (float)0.0f, (float)100000.0f);
        }
        return 0.0f;
    }

    @Override
    public void setRadiation(Level level, int x, int y, int z, float rad) {
        SimpleRadiationPerWorld radWorld = this.perWorld.get(level);
        if (radWorld != null && level.isLoaded(new BlockPos(x, y, z))) {
            ChunkPos coords = new ChunkPos(x >> 4, z >> 4);
            radWorld.radiation.put(coords, Float.valueOf(Mth.clamp((float)rad, (float)0.0f, (float)100000.0f)));
            level.getChunk(coords.x, coords.z).setUnsaved(true);
        }
    }

    @Override
    public void incrementRad(Level level, int x, int y, int z, float rad) {
        this.setRadiation(level, x, y, z, this.getRadiation(level, x, y, z) + rad);
    }

    @Override
    public void decrementRad(Level level, int x, int y, int z, float rad) {
        this.setRadiation(level, x, y, z, Math.max(this.getRadiation(level, x, y, z) - rad, 0.0f));
    }

    @Override
    public void updateSystem() {
        for (Map.Entry<Level, SimpleRadiationPerWorld> entry : this.perWorld.entrySet()) {
            HashMap<ChunkPos, Float> radiation = entry.getValue().radiation;
            HashMap<ChunkPos, Float> buff = new HashMap<ChunkPos, Float>(radiation);
            radiation.clear();
            Level level = entry.getKey();
            for (Map.Entry<ChunkPos, Float> chunk : buff.entrySet()) {
                if (chunk.getValue().floatValue() == 0.0f) continue;
                ChunkPos coord = chunk.getKey();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        int type = Math.abs(i) + Math.abs(j);
                        float percent = type == 0 ? 0.6f : (type == 1 ? 0.075f : 0.025f);
                        ChunkPos newCoord = new ChunkPos(coord.x + i, coord.z + j);
                        if (buff.containsKey(newCoord)) {
                            Float val = radiation.get(newCoord);
                            float rad = val == null ? 0.0f : val.floatValue();
                            float newRad = rad + chunk.getValue().floatValue() * percent;
                            newRad = Mth.clamp((float)0.0f, (float)(newRad * 0.99f - 0.05f), (float)100000.0f);
                            radiation.put(newCoord, Float.valueOf(newRad));
                        } else {
                            radiation.put(newCoord, Float.valueOf(chunk.getValue().floatValue() * percent));
                        }
                        float rad = radiation.get(newCoord).floatValue();
                        if (!(rad > (float)((Integer)MainConfig.COMMON.FOG_RAD.get()).intValue()) || level == null || level.random.nextInt(((Integer)MainConfig.COMMON.FOG_RAD_CH.get()).intValue()) != 0 || !level.hasChunk(coord.x, coord.z)) continue;
                        int x = newCoord.getMinBlockX() + level.random.nextInt(16);
                        int z = newCoord.getMinBlockZ() + level.random.nextInt(16);
                        int y = level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z) + level.random.nextInt(5);
                        CompoundTag data = new CompoundTag();
                        data.putString("type", "radFog");
                        data.putDouble("posX", (double)x);
                        data.putDouble("posY", (double)y);
                        data.putDouble("posZ", (double)z);
                        HBMsNTMClient.effectNT(data);
                    }
                }
            }
        }
    }

    @Override
    public void clearSystem(Level level) {
        SimpleRadiationPerWorld radWorld = this.perWorld.get(level);
        if (radWorld != null) {
            radWorld.radiation.clear();
        }
    }

    @Override
    public void receiveWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            this.perWorld.put((Level)serverLevel, new SimpleRadiationPerWorld());
        }
    }

    @Override
    public void receiveWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            this.perWorld.remove(serverLevel);
        }
    }

    @Override
    public void receiveChunkLoad(ChunkDataEvent.Load event) {
        Level level = (Level)event.getLevel();
        if (level.isClientSide) {
            return;
        }
        SimpleRadiationPerWorld radWorld = this.perWorld.get(level);
        if (radWorld != null) {
            radWorld.radiation.put(event.getChunk().getPos(), Float.valueOf(event.getData().getFloat(NBT_KEY_CHUNK_RADIATION)));
        }
    }

    @Override
    public void receiveChunkSave(ChunkDataEvent.Save event) {
        Level level = (Level)event.getLevel();
        if (level.isClientSide) {
            return;
        }
        SimpleRadiationPerWorld radWorld = this.perWorld.get(level);
        if (radWorld != null) {
            Float val = radWorld.radiation.get(event.getChunk().getPos());
            float rad = val == null ? 0.0f : val.floatValue();
            event.getData().putFloat(NBT_KEY_CHUNK_RADIATION, rad);
        }
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        Level level = (Level)event.getLevel();
        if (level.isClientSide) {
            return;
        }
        SimpleRadiationPerWorld radWorld = this.perWorld.get(level);
        if (radWorld != null) {
            radWorld.radiation.remove(event.getChunk().getPos());
        }
    }

    @Override
    public void handleWorldDestruction() {
        int count = 10;
        int threshold = 10;
        int chunks = 5;
        for (Map.Entry<Level, SimpleRadiationPerWorld> per : this.perWorld.entrySet()) {
            Level level = per.getKey();
            SimpleRadiationPerWorld list = per.getValue();
            Object[] entries = list.radiation.entrySet().toArray();
            if (entries.length == 0) continue;
            for (int c = 0; c < chunks; ++c) {
                Map.Entry randEnt = (Map.Entry)entries[level.random.nextInt(entries.length)];
                ChunkPos coords = (ChunkPos)randEnt.getKey();
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < count; ++i) {
                    if (randEnt == null || ((Float)randEnt.getValue()).floatValue() < (float)threshold || !serverLevel.hasChunk(coords.x, coords.z)) continue;
                    for (int a = 0; a < 16; ++a) {
                        for (int b = 0; b < 16; ++b) {
                            int z;
                            int y;
                            if (level.random.nextInt(3) != 0) continue;
                            int x = coords.getMinBlockX() + a;
                            BlockPos pos = new BlockPos(x, y = level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z = coords.getMinBlockZ() + b) - level.random.nextInt(2), z);
                            BlockState state = level.getBlockState(pos);
                            if (state.is(Blocks.GRASS_BLOCK)) {
                                level.setBlock(pos, ((Block)ModBlocks.WASTE_EARTH.get()).defaultBlockState(), 3);
                                continue;
                            }
                            if (state.is(Blocks.TALL_GRASS)) {
                                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                                continue;
                            }
                            if (!state.is(BlockTags.LEAVES)) continue;
                            if (level.random.nextInt(7) <= 5) {
                                level.setBlock(pos, ((Block)ModBlocks.WASTE_LEAVES.get()).defaultBlockState(), 3);
                                continue;
                            }
                            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                        }
                    }
                }
            }
        }
    }

    public static class SimpleRadiationPerWorld {
        public HashMap<ChunkPos, Float> radiation = new HashMap();
    }
}

