/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard;

import com.hbm.hazard.HazardData;
import com.hbm.hazard.HazardEntry;
import com.hbm.hazard.modifier.HazardModifier;
import com.hbm.hazard.transformer.HazardTransformerBase;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.inventory.RecipesCommon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class HazardSystem {
    public static final HashMap<TagKey<Item>, HazardData> tagMap = new HashMap();
    public static final HashMap<Item, HazardData> itemMap = new HashMap();
    public static final HashMap<RecipesCommon.ComparableStack, HazardData> stackMap = new HashMap();
    public static final HashSet<RecipesCommon.ComparableStack> stackBlacklist = new HashSet();
    public static final HashSet<TagKey<Item>> tagBlacklist = new HashSet();
    public static final List<HazardTransformerBase> trafos = new ArrayList<HazardTransformerBase>();

    public static void register(Object obj, HazardData data) {
        if (obj instanceof Item) {
            Item item = (Item)obj;
            itemMap.put(item, data);
        } else if (obj instanceof Block) {
            Block block = (Block)obj;
            itemMap.put(block.asItem(), data);
        } else if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            stackMap.put(new RecipesCommon.ComparableStack(stack), data);
        } else if (obj instanceof RecipesCommon.ComparableStack) {
            RecipesCommon.ComparableStack comp = (RecipesCommon.ComparableStack)obj;
            stackMap.put(comp, data);
        }
    }

    public static void blacklist(Object obj) {
        TagKey tagKey;
        if (obj instanceof TagKey && (tagKey = (TagKey)obj).isFor(Registries.ITEM)) {
            tagBlacklist.add((TagKey<Item>)tagKey);
        } else if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            stackBlacklist.add(new RecipesCommon.ComparableStack(stack).makeSingular());
        }
    }

    public static void blacklist(ResourceLocation tagLocation) {
        HazardSystem.blacklist(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagLocation));
    }

    public static boolean isItemBlacklisted(ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack).makeSingular();
        if (stackBlacklist.contains(comp)) {
            return true;
        }
        return stack.getTags().anyMatch(tagBlacklist::contains);
    }

    public static List<HazardEntry> getHazardsFromStack(ItemStack stack) {
        RecipesCommon.ComparableStack comp;
        if (HazardSystem.isItemBlacklisted(stack)) {
            return new ArrayList<HazardEntry>();
        }
        ArrayList<HazardData> chronological = new ArrayList<HazardData>();
        stack.getTags().forEach(tagKey -> {
            if (tagMap.containsKey(tagKey)) {
                chronological.add(tagMap.get(tagKey));
            }
        });
        if (itemMap.containsKey(stack.getItem())) {
            chronological.add(itemMap.get(stack.getItem()));
        }
        if (stackMap.containsKey(comp = new RecipesCommon.ComparableStack(stack).makeSingular())) {
            chronological.add(stackMap.get(comp));
        }
        ArrayList<HazardEntry> entries = new ArrayList<HazardEntry>();
        for (HazardTransformerBase trafo : trafos) {
            trafo.transformPre(stack, entries);
        }
        int mutex = 0;
        for (HazardData data : chronological) {
            if (data.doesOverride) {
                entries.clear();
            }
            if ((data.getMutex() & mutex) != 0) continue;
            entries.addAll(data.entries);
            mutex |= data.getMutex();
        }
        for (HazardTransformerBase trafo : trafos) {
            trafo.transformPost(stack, entries);
        }
        return entries;
    }

    public static float getHazardLevelFromStack(ItemStack stack, HazardTypeBase hazard) {
        List<HazardEntry> entries = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry entry : entries) {
            if (entry.type != hazard) continue;
            return HazardModifier.evalAllModifiers(stack, null, entry.baseLevel, entry.mods);
        }
        return 0.0f;
    }

    public static void applyHazards(ItemStack stack, LivingEntity entity) {
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry hazard : hazards) {
            hazard.applyHazard(stack, entity);
        }
    }

    public static void updatePlayerInventory(Player player) {
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty()) continue;
            HazardSystem.applyHazards(stack, (LivingEntity)player);
        }
        for (ItemStack stack : player.getInventory().armor) {
            if (stack.isEmpty()) continue;
            HazardSystem.applyHazards(stack, (LivingEntity)player);
        }
        for (ItemStack stack : player.getInventory().offhand) {
            if (stack.isEmpty()) continue;
            HazardSystem.applyHazards(stack, (LivingEntity)player);
        }
    }

    public static void updateLivingInventory(LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.getItemBySlot(slot);
            if (stack.isEmpty()) continue;
            HazardSystem.applyHazards(stack, entity);
        }
    }

    public static void updateDroppedItem(ItemEntity entity) {
        if (entity.isRemoved()) {
            return;
        }
        ItemStack stack = entity.getItem();
        if (stack.isEmpty()) {
            return;
        }
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry entry : hazards) {
            entry.type.updateEntity(entity, HazardModifier.evalAllModifiers(stack, null, entry.baseLevel, entry.mods));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addFullTooltip(ItemStack stack, List<Component> list) {
        LocalPlayer player = Minecraft.getInstance().player;
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry hazard : hazards) {
            hazard.type.addHazardInformation((Player)player, list, hazard.baseLevel, stack, hazard.mods);
        }
    }
}

