/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard.type;

import com.hbm.hazard.modifier.HazardModifier;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class HazardTypeDigamma
extends HazardTypeBase {
    @Override
    public void onUpdate(LivingEntity target, float level, ItemStack stack) {
        ContaminationUtil.applyDigammaData((Entity)target, level / 20.0f);
    }

    @Override
    public void updateEntity(ItemEntity item, float level) {
    }

    @Override
    public void addHazardInformation(Player player, List<Component> components, float level, ItemStack stack, List<HazardModifier> modifiers) {
        level = HazardModifier.evalAllModifiers(stack, (LivingEntity)player, level, modifiers);
        float digamma = (float)Math.floor(level * 10000.0f) / 10.0f;
        components.add((Component)Component.literal((String)("[" + I18nUtil.resolveKey("trait.digamma", new Object[0]) + "]")).withStyle(ChatFormatting.RED));
        components.add((Component)Component.literal((String)(digamma + "mDRX/s")));
        if (stack.getCount() > 1) {
            components.add((Component)Component.literal((String)("Stack: " + Math.floor(level * 10000.0f * (float)stack.getCount()) / 10.0 + "mDRX/s")).withStyle(ChatFormatting.DARK_RED));
        }
    }
}

