/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard.type;

import com.hbm.config.MainConfig;
import com.hbm.hazard.modifier.HazardModifier;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HazardTypeExplosive
extends HazardTypeBase {
    @Override
    public void onUpdate(LivingEntity target, float level, ItemStack stack) {
        if (((Boolean)MainConfig.COMMON.DISABLE_EXPLOSIVE.get()).booleanValue()) {
            return;
        }
        if (!target.level().isClientSide && (target.isOnFire() || target.isInLava()) && stack.getCount() > 0) {
            stack.setCount(0);
            target.level().explode(null, target.getX(), target.getY() + 2.0, target.getZ(), level, Level.ExplosionInteraction.TNT);
        }
    }

    @Override
    public void updateEntity(ItemEntity item, float level) {
        if (((Boolean)MainConfig.COMMON.DISABLE_EXPLOSIVE.get()).booleanValue()) {
            return;
        }
        if (item.isOnFire() || item.isInLava()) {
            item.discard();
            item.level().explode(null, item.getX(), item.getY(), item.getZ(), level, Level.ExplosionInteraction.TNT);
        }
    }

    @Override
    public void addHazardInformation(Player player, List<Component> components, float level, ItemStack stack, List<HazardModifier> modifiers) {
        components.add((Component)Component.literal((String)("[" + I18nUtil.resolveKey("trait.explosive", new Object[0]) + "]")).withStyle(ChatFormatting.RED));
    }
}

