/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.items.ModItems;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RecipesCommon {
    public static ItemStack[] copyStackArray(ItemStack[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            clone[i] = array[i].copy();
        }
        return clone;
    }

    public static ItemStack[] objectToStackArray(Object[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] instanceof ItemStack)) continue;
            clone[i] = (ItemStack)array[i];
        }
        return clone;
    }

    public static class StateBlock {
        public final BlockState state;

        public StateBlock(BlockState state) {
            this.state = state;
        }

        public StateBlock(Block block) {
            this(block.defaultBlockState());
        }

        public int hashCode() {
            return this.state.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StateBlock)) {
                return false;
            }
            StateBlock other = (StateBlock)obj;
            return this.state.equals(other.state);
        }
    }

    public static class OreDictStack
    extends AStack {
        private final TagKey<Item> tag;

        public OreDictStack(ResourceLocation tagName, int stackSize) {
            this.tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagName);
            this.stackSize = stackSize;
        }

        public OreDictStack(ResourceLocation tagName) {
            this(tagName, 1);
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            if (stack.isEmpty()) {
                return false;
            }
            if (!stack.is(this.tag)) {
                return false;
            }
            return ignoreSize || stack.getCount() >= this.stackSize;
        }

        @Override
        public AStack copy() {
            return new OreDictStack(this.tag.location(), this.stackSize);
        }

        @Override
        public List<ItemStack> extractForDisplay() {
            return List.of();
        }

        @Override
        public int compareTo(AStack o) {
            return 0;
        }
    }

    public static class ComparableStack
    extends AStack {
        public Item item;
        public int meta;

        public ComparableStack(ItemStack stack) {
            if (stack == null || stack.isEmpty()) {
                this.item = (Item)ModItems.NOTHING.get();
                this.stackSize = 1;
                this.meta = 0;
                return;
            }
            this.item = stack.getItem();
            this.stackSize = stack.getCount();
            this.meta = stack.getDamageValue();
        }

        public ComparableStack makeSingular() {
            this.stackSize = 1;
            return this;
        }

        public ComparableStack(Item item) {
            this.item = item == null ? (Item)ModItems.NOTHING.get() : item;
            this.stackSize = 1;
            this.meta = 0;
        }

        public ComparableStack(Block block) {
            this(block.asItem());
        }

        public ComparableStack(Item item, int stacksize, int meta) {
            this.item = item == null ? (Item)ModItems.NOTHING.get() : item;
            this.stackSize = stacksize;
            this.meta = meta;
        }

        public ItemStack toStack() {
            return new ItemStack((ItemLike)(this.item == null ? (ItemLike)ModItems.NOTHING.get() : this.item), this.stackSize);
        }

        public int hashCode() {
            return Objects.hash(BuiltInRegistries.ITEM.getKey((Object)this.item), this.meta, this.stackSize);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ComparableStack)) {
                return false;
            }
            ComparableStack other = (ComparableStack)obj;
            if (!Objects.equals(this.item, other.item)) {
                return false;
            }
            if (this.meta != other.meta) {
                return false;
            }
            return this.stackSize == other.stackSize;
        }

        @Override
        public int compareTo(AStack stack) {
            if (stack instanceof ComparableStack) {
                ComparableStack comp = (ComparableStack)stack;
                int cmp = BuiltInRegistries.ITEM.getKey((Object)this.item).compareTo(BuiltInRegistries.ITEM.getKey((Object)comp.item));
                if (cmp != 0) {
                    return cmp;
                }
                return Integer.compare(this.meta, comp.meta);
            }
            return 0;
        }

        @Override
        public AStack copy() {
            return new ComparableStack(this.item, this.stackSize, this.meta);
        }

        @Override
        public List<ItemStack> extractForDisplay() {
            return List.of();
        }

        public ComparableStack copy(int stacksize) {
            return new ComparableStack(this.item, stacksize, this.meta);
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            if (stack.isEmpty()) {
                return false;
            }
            if (stack.getItem() != this.item) {
                return false;
            }
            if (this.meta != -1 && stack.getDamageValue() != this.meta) {
                return false;
            }
            return ignoreSize || stack.getCount() >= this.stackSize;
        }
    }

    public static abstract class AStack
    implements Comparable<AStack> {
        protected int stackSize;

        public boolean isApplicable(ItemStack stack) {
            return this.isApplicable(new ComparableStack(stack));
        }

        public boolean isApplicable(ComparableStack comp) {
            AStack aStack = this;
            if (aStack instanceof ComparableStack) {
                ComparableStack cs = (ComparableStack)aStack;
                return cs.equals(comp);
            }
            aStack = this;
            if (aStack instanceof OreDictStack) {
                OreDictStack odStack = (OreDictStack)aStack;
                return comp.toStack().is(odStack.getTag());
            }
            return false;
        }

        public abstract boolean matchesRecipe(ItemStack var1, boolean var2);

        public abstract AStack copy();

        public abstract List<ItemStack> extractForDisplay();

        public ItemStack extractForCyclingDisplay(int cycle) {
            List<ItemStack> list = this.extractForDisplay();
            cycle *= 50;
            if (list.isEmpty()) {
                return new ItemStack((ItemLike)ModItems.NOTHING.get());
            }
            int index = (int)(System.currentTimeMillis() % ((long)cycle * (long)list.size()) / (long)cycle);
            return list.get(index);
        }

        public int getStackSize() {
            return this.stackSize;
        }

        public void setStackSize(int size) {
            this.stackSize = size;
        }
    }
}

