/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.handler.HTTPHandler;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class LoadingScreenRendererNT {
    private final Minecraft mc;
    private String currentlyDisplayedText = "";
    public String tipOfTheDay = "Tip of the day: " + this.chooseTip();

    public LoadingScreenRendererNT(Minecraft mc) {
        this.mc = mc;
    }

    private String chooseTip() {
        if (HTTPHandler.tipOfTheDay.isEmpty()) {
            return "Explore! There's tons of free stuff to find.";
        }
        return HTTPHandler.tipOfTheDay.get(new Random().nextInt(HTTPHandler.tipOfTheDay.size()));
    }

    public void resetProgressAndMessage(String message) {
        this.setMessage(message);
        this.tipOfTheDay = !HTTPHandler.tipOfTheDay.isEmpty() ? "Tip of the day: " + HTTPHandler.tipOfTheDay.get(new Random().nextInt(HTTPHandler.tipOfTheDay.size())) : "Explore! There's tons of free stuff to find.";
    }

    private void setMessage(String message) {
        this.currentlyDisplayedText = message;
    }

    public void render(GuiGraphics gg, int progress) {
        int width = this.mc.getWindow().getGuiScaledWidth();
        int height = this.mc.getWindow().getGuiScaledHeight();
        if (progress >= 0) {
            int barWidth = 100;
            int barHeight = 2;
            int x = width / 2 - barWidth / 2;
            int y = height / 2 + 16;
            int clamped = Math.min(progress, barWidth);
            gg.fill(x, y, x + barWidth, y + barHeight, -8355712);
            gg.fill(x, y, x + clamped, y + barHeight, -16711936);
        }
        gg.drawCenteredString(this.mc.font, this.currentlyDisplayedText, width / 2, height / 2 - 20, 0xFFFFFF);
        String message = "";
        gg.drawCenteredString(this.mc.font, message, width / 2, height / 2 - 4, 0xFFFFFF);
        String[] frags = this.tipOfTheDay.split("\\$");
        int n = height / 2 - 60;
        Objects.requireNonNull(this.mc.font);
        int baseY = n - 9;
        for (int i = 0; i < frags.length; ++i) {
            String frag = frags[i];
            Font font = this.mc.font;
            String string = String.valueOf(ChatFormatting.YELLOW) + frag;
            int n2 = width / 2;
            Objects.requireNonNull(this.mc.font);
            gg.drawCenteredString(font, string, n2, baseY + i * 9, 0xFFFFFF);
        }
    }
}

