/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items;

import com.hbm.util.ItemStackUtil;
import com.hbm.util.TagsUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class ItemInventory
extends SimpleContainer {
    protected Player player;
    public NonNullList<ItemStack> slots;
    protected ItemStack target;

    public ItemInventory(Player player, ItemStack target, int size) {
        super(size);
        this.player = player;
        this.target = target;
    }

    public void setChanged() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty() || stack.getCount() != 0) continue;
            this.setItem(i, ItemStack.EMPTY);
        }
        ItemStackUtil.addStacksToNBT(this.player.level().registryAccess(), this.target, new ItemStack[0]);
        TagsUtil.setTag(this.target, this.checkNBT(TagsUtil.getTag(this.target)));
    }

    public CompoundTag checkNBT(CompoundTag tag) {
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        Random random = new Random();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)baos);
            byte[] data = baos.toByteArray();
            if (data.length > 6000) {
                this.player.displayClientMessage((Component)Component.literal((String)"\u00a7cWarning: Container NBT exceeds 6kB, contents will be ejected!"), false);
                Level level = this.player.level();
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    ItemStack stack = this.getItem(i);
                    if (stack.isEmpty()) continue;
                    float fx = random.nextFloat() * 0.8f + 0.1f;
                    float fy = random.nextFloat() * 0.8f + 0.1f;
                    float fz = random.nextFloat() * 0.8f + 0.1f;
                    while (!stack.isEmpty()) {
                        int dropCount = Math.min(random.nextInt(21) + 10, stack.getCount());
                        ItemStack drop = stack.split(dropCount);
                        ItemEntity entity = new ItemEntity(level, this.player.getX() + (double)fx, this.player.getY() + (double)fy, this.player.getZ() + (double)fz, drop);
                        entity.setDeltaMovement(random.nextGaussian() * 0.05 + this.player.getDeltaMovement().x, random.nextGaussian() * 0.05 + 0.2 + this.player.getDeltaMovement().y, random.nextGaussian() * 0.05 + this.player.getDeltaMovement().z);
                        level.addFreshEntity((Entity)entity);
                    }
                }
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tag;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.getItem(slot);
        if (!stack.isEmpty()) {
            ItemStack result = stack.split(amount);
            if (!result.isEmpty()) {
                this.setChanged();
                return result;
            }
            this.slots.set(slot, (Object)ItemStack.EMPTY);
        }
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.slots.set(slot, (Object)stack);
        this.setChanged();
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.getItem(slot);
        this.slots.set(slot, (Object)ItemStack.EMPTY);
        return stack;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.slots.get(slot);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return true;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void startOpen(Player player) {
        player.level().playSound(null, player.blockPosition(), SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 1.0f, 0.8f);
    }

    public void stopOpen(Player player) {
        player.level().playSound(null, player.blockPosition(), SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 1.0f, 0.8f);
    }
}

