/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.block;

import com.hbm.blocks.IBlockMulti;
import com.hbm.blocks.IPersistentInfoProvider;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.util.TagsUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class ItemBlockBase
extends BlockItem {
    public ItemBlockBase(Block block, Item.Properties props) {
        super(block, props);
    }

    public Component getName(ItemStack stack) {
        Block block = this.getBlock();
        if (block instanceof IBlockMulti) {
            IBlockMulti multi = (IBlockMulti)block;
            String override = multi.getOverrideDisplayName(stack);
            return Component.translatable((String)Objects.requireNonNullElseGet(override, () -> multi.getUnlocalizedName(stack) + ".name"));
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Block block = this.getBlock();
        if (block instanceof ITooltipProvider) {
            ITooltipProvider tipProvider = (ITooltipProvider)block;
            tipProvider.addInformation(stack, context, tooltipComponents, tooltipFlag);
        }
        if (block instanceof IPersistentInfoProvider) {
            CompoundTag data;
            IPersistentInfoProvider infoProvider = (IPersistentInfoProvider)block;
            if (TagsUtil.hasTag(stack) && (data = TagsUtil.getTagElement(stack, "persistent")) != null) {
                infoProvider.addInformation(stack, context, tooltipComponents, tooltipFlag);
            }
        }
    }
}

