/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.block;

import com.hbm.blockentity.machine.storage.CrateBaseBlockEntity;
import com.hbm.blockentity.machine.storage.CrateIronBlockEntity;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.container.ContainerCrateIron;
import com.hbm.items.ItemInventory;
import com.hbm.items.block.ItemBlockBase;
import com.hbm.items.tools.KeyItem;
import com.hbm.util.TagsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemBlockStorageCrate
extends ItemBlockBase {
    public ItemBlockStorageCrate(Block block, Item.Properties props) {
        super(block, props);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && stack.getCount() == 1) {
            BlockPos pos = player.blockPosition();
            CompoundTag tag = TagsUtil.getTag(stack);
            if (tag.contains("lock")) {
                for (ItemStack item : player.getInventory().items) {
                    CompoundTag keyTag;
                    if (item.isEmpty() || !(item.getItem() instanceof KeyItem) || (keyTag = TagsUtil.getTag(stack)).getInt("pins") != tag.getInt("lock")) continue;
                    CrateBaseBlockEntity.spawnSpiders(player, level, stack);
                    this.openGui(player, level, pos);
                    break;
                }
                return InteractionResultHolder.success((Object)stack);
            }
            CrateBaseBlockEntity.spawnSpiders(player, level, stack);
            this.openGui(player, level, pos);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private void openGui(Player player, Level level, BlockPos pos) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            CrateBaseBlockEntity crate;
            ServerPlayer sp = (ServerPlayer)player;
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof CrateBaseBlockEntity && (crate = (CrateBaseBlockEntity)be).canAccess(player)) {
                sp.openMenu((MenuProvider)crate, pos);
            }
        }
    }

    private AbstractContainerMenu createMenu(int id, Inventory playerInv, ItemStack stack) {
        Block block = Block.byItem((Item)stack.getItem());
        if (block == ModBlocks.IRON_CRATE.get()) {
            return new ContainerCrateIron(id, playerInv, (Container)new InventoryCrate(playerInv.player, stack));
        }
        throw new NullPointerException();
    }

    public static class InventoryCrate
    extends ItemInventory {
        public InventoryCrate(Player player, ItemStack crate) {
            super(player, crate, 27);
            this.player = player;
            this.target = crate;
        }

        public static CrateBaseBlockEntity findCrateType(Item crate) {
            Block block = Block.byItem((Item)crate);
            if (block == ModBlocks.IRON_CRATE.get()) {
                return new CrateIronBlockEntity(BlockPos.ZERO, ((Block)ModBlocks.IRON_CRATE.get()).defaultBlockState());
            }
            throw new NullPointerException();
        }

        public int getContainerSize() {
            return InventoryCrate.findCrateType(this.target.getItem()).getContainerSize();
        }

        @Override
        public void setChanged() {
            CompoundTag nbt = TagsUtil.getOrCreateTag(this.target);
            int invSize = this.getContainerSize();
            for (int i = 0; i < invSize; ++i) {
                ItemStack stack = this.getItem(i);
                if (stack.isEmpty()) {
                    nbt.remove("slot" + i);
                    continue;
                }
                CompoundTag slot = new CompoundTag();
                stack.save((HolderLookup.Provider)slot);
                nbt.put("slot" + i, (Tag)slot);
            }
            if (nbt.isEmpty()) {
                TagsUtil.setTag(this.target, null);
            }
        }

        @Override
        public void stopOpen(Player player) {
            super.stopOpen(player);
            TagsUtil.setTag(this.target, this.checkNBT(TagsUtil.getTag(this.target)));
            player.containerMenu.broadcastChanges();
        }

        public InventoryCrate() {
            super(null, ItemStack.EMPTY, 27);
        }
    }
}

