/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.HBMsNTM;
import com.hbm.config.MainConfig;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.interfaces.IBomb;
import com.hbm.items.ModItems;
import com.hbm.lib.ModSounds;
import com.hbm.util.TagsUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DangerousDropItem
extends Item {
    public DangerousDropItem(Item.Properties properties) {
        super(properties);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        Level level = itemEntity.level();
        if (level.isClientSide) {
            return false;
        }
        int lifespan = stack.getEntityLifespan(level);
        if (itemEntity.getAge() >= lifespan - 1) {
            return false;
        }
        String throwerName = "";
        if (TagsUtil.hasTag(stack)) {
            throwerName = TagsUtil.getString(stack, "lastUser", "Somebody");
        }
        if (itemEntity.getAge() > 5) {
            if (stack.is((Item)ModItems.DETONATOR_DEADMAN.get())) {
                int z;
                int y;
                int x;
                Block block;
                if (TagsUtil.hasTag(stack) && (block = level.getBlockState(new BlockPos(x = TagsUtil.getInt(stack, "x", 0), y = TagsUtil.getInt(stack, "y", 0), z = TagsUtil.getInt(stack, "z", 0))).getBlock()) instanceof IBomb) {
                    IBomb bomb = (IBomb)block;
                    bomb.explode(level, x, y, z);
                    if (((Boolean)MainConfig.COMMON.ENABLE_EXTENDED_LOGGING.get()).booleanValue()) {
                        HBMsNTM.LOGGER.info("[DEAD MAN'S DETONATOR] {} detonated {} at {} / {} / {}!", new Object[]{throwerName, block.getName().getString(), x, y, z});
                    }
                }
                level.explode(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), 0.0f, Level.ExplosionInteraction.NONE);
                itemEntity.discard();
                return true;
            }
            if (stack.is((Item)ModItems.DETONATOR_DE.get()) && ((Boolean)MainConfig.COMMON.DROP_DEAD_MANS_EXPLOSIVE.get()).booleanValue()) {
                level.explode(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), 15.0f, Level.ExplosionInteraction.TNT);
                itemEntity.discard();
                return true;
            }
        }
        if (itemEntity.onGround() && stack.is((Item)ModItems.CELL_ANTIMATTER.get()) && ((Boolean)MainConfig.COMMON.DROP_CELL.get()).booleanValue()) {
            new ExplosionVNT(level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), 5.0f).makeAmat().explode();
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this == ModItems.CELL_ANTIMATTER.get()) {
            tooltipComponents.add((Component)Component.literal((String)"Warning: Exposure to matter will"));
            tooltipComponents.add((Component)Component.literal((String)"lead to violent annihilation!"));
        }
        if (this == ModItems.DETONATOR_DEADMAN.get()) {
            tooltipComponents.add((Component)Component.literal((String)"Shift right-click to set position,"));
            tooltipComponents.add((Component)Component.literal((String)"drop to detonate!"));
            if (!TagsUtil.hasTag(stack)) {
                tooltipComponents.add((Component)Component.literal((String)"No position set!"));
            } else {
                tooltipComponents.add((Component)Component.literal((String)("Set position to " + TagsUtil.getInt(stack, "x", 0) + ", " + TagsUtil.getInt(stack, "y", 0) + ", " + TagsUtil.getInt(stack, "z", 0))));
            }
        }
        if (this == ModItems.DETONATOR_DE.get()) {
            tooltipComponents.add((Component)Component.literal((String)"Explodes when dropped!"));
        }
        tooltipComponents.add((Component)Component.literal((String)("[" + I18nUtil.resolveKey("trait.drop", new Object[0]) + "]")).withStyle(ChatFormatting.RED));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (this != ModItems.DETONATOR_DEADMAN.get()) {
            return super.onItemUseFirst(stack, context);
        }
        Player player = context.getPlayer();
        if (player.isCrouching()) {
            TagsUtil.setInt(stack, "x", context.getClickedPos().getX());
            TagsUtil.setInt(stack, "y", context.getClickedPos().getY());
            TagsUtil.setInt(stack, "z", context.getClickedPos().getZ());
            TagsUtil.setString(stack, "lastUser", player.getName().getString());
            if (!context.getLevel().isClientSide) {
                player.sendSystemMessage((Component)Component.literal((String)"Position set!"));
            }
            context.getLevel().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.TECH_BOOP.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

