/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tools;

import com.hbm.extprop.LivingProperties;
import com.hbm.items.tools.GeigerCounterItem;
import com.hbm.lib.ModSounds;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DosimeterItem
extends Item {
    private final Random rand = new Random();

    public DosimeterItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.isClientSide || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        float x = LivingProperties.getRadBuf(living);
        if (level.getGameTime() % 5L == 0L) {
            if ((double)x > 1.0E-5) {
                int r;
                ArrayList<Integer> list = new ArrayList<Integer>();
                if ((double)x < 0.5) {
                    list.add(0);
                }
                if (x < 1.0f) {
                    list.add(1);
                }
                if ((double)x >= 0.5 && x < 2.0f) {
                    list.add(2);
                }
                if (x >= 2.0f) {
                    list.add(3);
                }
                if ((r = ((Integer)list.get(this.rand.nextInt(list.size()))).intValue()) > 0) {
                    switch (r) {
                        case 1: {
                            GeigerCounterItem.playSnd(level, entity, (SoundEvent)ModSounds.GEIGER1.get());
                            break;
                        }
                        case 2: {
                            GeigerCounterItem.playSnd(level, entity, (SoundEvent)ModSounds.GEIGER2.get());
                            break;
                        }
                        case 3: {
                            GeigerCounterItem.playSnd(level, entity, (SoundEvent)ModSounds.GEIGER3.get());
                        }
                    }
                }
            } else if (this.rand.nextInt(100) == 0) {
                GeigerCounterItem.playSoundRand(level, entity, 1 + this.rand.nextInt(1));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            ContaminationUtil.printDosimeterData(player);
            level.playSound(null, player.blockPosition(), (SoundEvent)ModSounds.TECH_BOOP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

