/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tools;

import com.hbm.extprop.LivingProperties;
import com.hbm.lib.ModSounds;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GeigerCounterItem
extends Item {
    private final Random rand = new Random();

    public GeigerCounterItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.isClientSide || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        float x = LivingProperties.getRadBuf(living);
        if (level.getGameTime() % 5L == 0L) {
            if ((double)x > 1.0E-5) {
                int r;
                ArrayList<Integer> list = new ArrayList<Integer>();
                if (x < 1.0f) {
                    list.add(0);
                }
                if (x < 5.0f) {
                    list.add(0);
                }
                if (x < 10.0f) {
                    list.add(1);
                }
                if (x > 5.0f && x < 15.0f) {
                    list.add(2);
                }
                if (x > 10.0f && x < 20.0f) {
                    list.add(3);
                }
                if (x > 15.0f && x < 25.0f) {
                    list.add(4);
                }
                if (x > 20.0f && x < 30.0f) {
                    list.add(5);
                }
                if (x > 25.0f) {
                    list.add(6);
                }
                if ((r = ((Integer)list.get(this.rand.nextInt(list.size()))).intValue()) > 0) {
                    switch (r) {
                        case 1: {
                            GeigerCounterItem.playSnd(level, entity, (SoundEvent)ModSounds.GEIGER1.get());
                            break;
                        }
                        case 2: {
                            GeigerCounterItem.playSnd(level, entity, (SoundEvent)ModSounds.GEIGER2.get());
                            break;
                        }
                        case 3: {
                            GeigerCounterItem.playSnd(level, entity, (SoundEvent)ModSounds.GEIGER3.get());
                            break;
                        }
                        case 4: {
                            GeigerCounterItem.playSnd(level, entity, (SoundEvent)ModSounds.GEIGER4.get());
                            break;
                        }
                        case 5: {
                            GeigerCounterItem.playSnd(level, entity, (SoundEvent)ModSounds.GEIGER5.get());
                            break;
                        }
                        case 6: {
                            GeigerCounterItem.playSnd(level, entity, (SoundEvent)ModSounds.GEIGER6.get());
                        }
                    }
                }
            } else if (this.rand.nextInt(50) == 0) {
                GeigerCounterItem.playSoundRand(level, entity, 1 + this.rand.nextInt(1));
            }
        }
    }

    protected static void playSnd(Level level, Entity entity, SoundEvent soundEvent) {
        level.playSound(null, entity.blockPosition(), soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    protected static void playSoundRand(Level level, Entity entity, int i) {
        switch (i) {
            case 1: {
                level.playSound(null, entity.blockPosition(), (SoundEvent)ModSounds.GEIGER1.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                level.playSound(null, entity.blockPosition(), (SoundEvent)ModSounds.GEIGER2.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (!player.isCrouching()) {
                ContaminationUtil.printGeigerData(player);
                level.playSound(null, player.blockPosition(), (SoundEvent)ModSounds.TECH_BOOP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                ContaminationUtil.printDiagnosticData(player);
                level.playSound(null, player.blockPosition(), (SoundEvent)ModSounds.TECH_BOOP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

