/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.lib;

import com.hbm.extprop.LivingProperties;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ModCommands {
    private static final SuggestionProvider<CommandSourceStack> LivingProperties_SUGGESTION = (context, builder) -> {
        builder.suggest("radiation");
        builder.suggest("digamma");
        builder.suggest("asbestos");
        builder.suggest("blacklung");
        builder.suggest("oil");
        builder.suggest("fire");
        builder.suggest("phosphorus");
        builder.suggest("balefire");
        builder.suggest("blackfire");
        return builder.buildFuture();
    };

    public static void registerCommandLivingProperties(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"NTMLivingProperties").requires(src -> src.hasPermission(4))).then(Commands.literal((String)"get").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"field", (ArgumentType)StringArgumentType.word()).suggests(LivingProperties_SUGGESTION).executes(context -> {
            String value;
            LivingEntity livingEntity;
            Entity targetEntity = EntityArgument.getEntity((CommandContext)context, (String)"target");
            if (!(targetEntity instanceof LivingEntity)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Target is not a living entity!"));
                return 0;
            }
            LivingEntity target = livingEntity = (LivingEntity)targetEntity;
            String field = StringArgumentType.getString((CommandContext)context, (String)"field");
            LivingProperties data = LivingProperties.getData(target);
            switch (field.toLowerCase()) {
                case "radiation": {
                    value = String.valueOf(LivingProperties.getRadiation(target));
                    break;
                }
                case "digamma": {
                    value = String.valueOf(LivingProperties.getDigamma(target));
                    break;
                }
                case "asbestos": {
                    value = String.valueOf(LivingProperties.getAsbestos(target));
                    break;
                }
                case "blacklung": {
                    value = String.valueOf(LivingProperties.getBlackLung(target));
                    break;
                }
                case "oil": {
                    value = String.valueOf(LivingProperties.getOil(target));
                    break;
                }
                case "fire": {
                    value = String.valueOf(data.fire);
                    break;
                }
                case "phosphorus": {
                    value = String.valueOf(data.phosphorus);
                    break;
                }
                case "balefire": {
                    value = String.valueOf(data.balefire);
                    break;
                }
                case "blackfire": {
                    value = String.valueOf(data.blackFire);
                    break;
                }
                default: {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Unknown field: " + field)));
                    return 0;
                }
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Field '" + field + "' at " + target.getName().getString() + " = " + value)), false);
            return 1;
        }))))).then(Commands.literal((String)"set").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"field", (ArgumentType)StringArgumentType.word()).suggests(LivingProperties_SUGGESTION).then(Commands.argument((String)"set", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            LivingEntity livingEntity;
            Entity targetEntity = EntityArgument.getEntity((CommandContext)context, (String)"target");
            if (!(targetEntity instanceof LivingEntity)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Target is not a living entity!"));
                return 0;
            }
            LivingEntity target = livingEntity = (LivingEntity)targetEntity;
            String field = StringArgumentType.getString((CommandContext)context, (String)"field");
            float set = FloatArgumentType.getFloat((CommandContext)context, (String)"set");
            LivingProperties data = LivingProperties.getData(target);
            switch (field.toLowerCase()) {
                case "radiation": {
                    LivingProperties.setRadiation(target, set);
                    break;
                }
                case "digamma": {
                    LivingProperties.setDigamma(target, set);
                    break;
                }
                case "asbestos": {
                    LivingProperties.setAsbestos(target, (int)set);
                    break;
                }
                case "blacklung": {
                    LivingProperties.setBlackLung(target, (int)set);
                    break;
                }
                case "oil": {
                    LivingProperties.setOil(target, (int)set);
                    break;
                }
                case "fire": {
                    data.fire = (int)set;
                    break;
                }
                case "phosphorus": {
                    data.phosphorus = (int)set;
                    break;
                }
                case "balefire": {
                    data.balefire = (int)set;
                    break;
                }
                case "blackfire": {
                    data.blackFire = (int)set;
                    break;
                }
                default: {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Unknown field: " + field)));
                    return 0;
                }
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Field '" + field + "' at " + target.getName().getString() + " got changed by " + set)), true);
            return 1;
        }))))));
    }
}

