/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toclient;

import com.hbm.HBMsNTM;
import com.hbm.blockentity.IBufPacketReceiver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record BufNT(BlockPos pos, FriendlyByteBuf payload) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BufNT> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"buf"));
    public static final StreamCodec<FriendlyByteBuf, BufNT> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, BufNT>(){

        public BufNT decode(FriendlyByteBuf buf) {
            BlockPos pos = buf.readBlockPos();
            FriendlyByteBuf copy = new FriendlyByteBuf(Unpooled.copiedBuffer((ByteBuf)buf.readBytes(buf.readableBytes())));
            return new BufNT(pos, copy);
        }

        public void encode(FriendlyByteBuf buf, BufNT packet) {
            buf.writeBlockPos(packet.pos);
            buf.writeBytes((ByteBuf)packet.payload);
        }
    };

    public static void handleClient(BufNT packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return;
            }
            BlockEntity be = level.getBlockEntity(packet.pos());
            if (be instanceof IBufPacketReceiver) {
                IBufPacketReceiver receiver = (IBufPacketReceiver)be;
                try {
                    receiver.deserialize((ByteBuf)packet.payload());
                }
                catch (Exception e) {
                    HBMsNTM.LOGGER.warn("Error reading ByteBuf package: {}", (Object)e.getMessage());
                    HBMsNTM.LOGGER.warn("Tile: {}", (Object)be.getBlockState().getBlock().getName().getString());
                }
                finally {
                    packet.payload().release();
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

