/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toclient;

import com.hbm.explosion.vanillant.standard.ExplosionEffectStandard;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ExplosionVanillaNewTechnologyCompressedAffectedBlockPositionDataForClientEffectsAndParticleHandlingPacket(double posX, double posY, double posZ, float size, List<BlockPos> affectedBlocks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ExplosionVanillaNewTechnologyCompressedAffectedBlockPositionDataForClientEffectsAndParticleHandlingPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"explosion_vnt_blocks"));
    public static final StreamCodec<FriendlyByteBuf, ExplosionVanillaNewTechnologyCompressedAffectedBlockPositionDataForClientEffectsAndParticleHandlingPacket> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ExplosionVanillaNewTechnologyCompressedAffectedBlockPositionDataForClientEffectsAndParticleHandlingPacket>(){

        public ExplosionVanillaNewTechnologyCompressedAffectedBlockPositionDataForClientEffectsAndParticleHandlingPacket decode(FriendlyByteBuf buf) {
            double x = buf.readFloat();
            double y = buf.readFloat();
            double z = buf.readFloat();
            float size = buf.readFloat();
            int count = buf.readInt();
            ArrayList<BlockPos> list = new ArrayList<BlockPos>(count);
            int baseX = (int)x;
            int baseY = (int)y;
            int baseZ = (int)z;
            for (int i = 0; i < count; ++i) {
                byte dx = buf.readByte();
                byte dy = buf.readByte();
                byte dz = buf.readByte();
                list.add(new BlockPos(baseX + dx, baseY + dy, baseZ + dz));
            }
            return new ExplosionVanillaNewTechnologyCompressedAffectedBlockPositionDataForClientEffectsAndParticleHandlingPacket(x, y, z, size, list);
        }

        public void encode(FriendlyByteBuf buf, ExplosionVanillaNewTechnologyCompressedAffectedBlockPositionDataForClientEffectsAndParticleHandlingPacket pkt) {
            buf.writeFloat((float)pkt.posX);
            buf.writeFloat((float)pkt.posY);
            buf.writeFloat((float)pkt.posZ);
            buf.writeFloat(pkt.size);
            buf.writeInt(pkt.affectedBlocks.size());
            int baseX = (int)pkt.posX;
            int baseY = (int)pkt.posY;
            int baseZ = (int)pkt.posZ;
            for (BlockPos pos : pkt.affectedBlocks) {
                buf.writeByte(pos.getX() - baseX);
                buf.writeByte(pos.getY() - baseY);
                buf.writeByte(pos.getZ() - baseZ);
            }
        }
    };

    public static void handleClient(ExplosionVanillaNewTechnologyCompressedAffectedBlockPositionDataForClientEffectsAndParticleHandlingPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                ExplosionEffectStandard.performClient((Level)mc.level, packet.posX(), packet.posY(), packet.posZ(), packet.size(), packet.affectedBlocks());
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

